package com.cv.media.lib.plugin;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;

import com.cv.media.lib.common_utils.utils.Singleton;
import com.cv.media.lib.factory.ResFactory;

import com.cv.media.lib.storage.mmkv.CommonPreference;

import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

import dalvik.system.DexClassLoader;

public class ResourceManager {

    private static final String TAG = "ResourceManager";

    public static String RES_PLUGIN_PATH = File.separator + "plugin_apk" + File.separator + "plugin_res.apk";
    public static String RES_PLUGIN_PATH_OTA = File.separator + "plugin_apk" + File.separator;
    public static String RES_PLUGIN_NAME = "plugin_res.apk";
    public static String RES_PLUGIN_PACKAGE_NAME = "com.cv.media.lib.plugin";

    private Map<String, ResourcesPlugin> mResources = new HashMap<String, ResourcesPlugin>();
    private Map<String, MyResources> mResMap = new HashMap<String, MyResources>();
    private Context mContext;
    private String mPluginDir;
    private ResourcesPlugin mPluginResources;

    private PackageInfo mPackageInfo;
    private Map<String, ResFactory> mResFactoryMap = new HashMap<>();

    private static final Singleton<ResourceManager> mSingleton = new Singleton<ResourceManager>() {
        @Override
        protected ResourceManager create() {
            return new ResourceManager();
        }
    };

    public static ResourceManager getInstance() {
        return mSingleton.get();
    }

    public void initPlugin(Application application) {
        Log.d("plugin", "------initPlugin()");
        mContext = application.getApplicationContext();
        if (!(new File(ContextCompat.getDataDir(mContext).getAbsolutePath() + ResourceManager.RES_PLUGIN_PATH).exists())) {
            Log.w(TAG, "resource apk not founded");
            return;
        }
        File dexDir = mContext.getDir("plugin", Context.MODE_PRIVATE);
        if (!dexDir.exists()) {
            dexDir.mkdir();
        }
        mPluginDir = dexDir.getAbsolutePath();
        mPluginResources = loadResource(ContextCompat.getDataDir(mContext).getAbsolutePath() + ResourceManager.RES_PLUGIN_PATH);
        Log.d("plugin", "------loadResource() = " + mPluginDir);
    }

    public void initAppLifeCycle(Application application) {
        Log.d("plugin", "------initAppLifeCycle()");
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks() {

            @Override
            public void onActivityPreCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {

            }

            @Override
            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
                Log.d("plugin", "------>onActivityCreated()." + activity.getLocalClassName());
                if (activity instanceof AppCompatActivity) {
                    //return;
                }
                if (null != mPluginResources) {
                    Log.d("plugin", "------000000");
                    ResFactory mResFactory = new ResFactory();
                    mResFactoryMap.put(activity.getLocalClassName(), mResFactory);
                    activity.getLayoutInflater().setFactory(mResFactory);
                }

                if (Build.VERSION.SDK_INT == 28 && activity.getLocalClassName().equals("com.cv.media.m.home.home.ui.HomeActivity")) {
                    //return;
                }
                if (null != mPluginResources) {
                    Log.d("plugin", "------111111");
                    MyResources myResources = new MyResources(mContext, activity.getResources(), mPluginResources);
                    mResMap.put(activity.getLocalClassName(), myResources);
                    ReflectionUtils.setFieldValue(activity, "mResources", myResources);
                }
            }

            @Override
            public void onActivityStarted(@NonNull Activity activity) {

            }

            @Override
            public void onActivityResumed(@NonNull Activity activity) {
                if (activity instanceof AppCompatActivity) {
                    //return;
                }
                if (null != mPluginResources && null != mResFactoryMap && mResFactoryMap.get(activity.getLocalClassName()) != null) {
                    Log.d("plugin", "------222222");
                    mResFactoryMap.get(activity.getLocalClassName()).apply();
                }

                if (Build.VERSION.SDK_INT == 28 && activity.getLocalClassName().equals("com.cv.media.m.home.home.ui.HomeActivity")) {
                    //return;
                }
                if (null != mPluginResources) {
                    Log.d("plugin", "------333333");
                    MyResources myResources = new MyResources(mContext, activity.getResources(), mPluginResources);
                    ReflectionUtils.setFieldValue(activity, "mResources", myResources);
//                    if (null != mPluginResources && null != mResMap && null != mResMap.get(activity.getLocalClassName())) {
//                        Log.d("plugin", "------444444");
//                        ReflectionUtils.setFieldValue(activity, "mResources", mResMap.get(activity.getLocalClassName()));
//                    }
                }
            }

            @Override
            public void onActivityPaused(@NonNull Activity activity) {

            }

            @Override
            public void onActivityStopped(@NonNull Activity activity) {

            }

            @Override
            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {

            }

            @Override
            public void onActivityDestroyed(@NonNull Activity activity) {

            }
        });
    }

    /*
    public void initInActivity(Activity activity) {
        if (null != mPluginResources) {
            MyResources myResources = new MyResources(mContext, activity.getResources(), mPluginResources);
            ReflectionUtils.setFieldValue(activity, "mResources", myResources);
        }
    }
     */

    public ResourcesPlugin loadResource(String resourcePath) {
        ResourcesPlugin loadResource = null;
        mPackageInfo = queryPackageInfo(resourcePath);//获取未安装APK的PackageInfo
        if (mPackageInfo != null) {//获取成功
            //loadResource = mResources.get(mPackageInfo.packageName);//先从缓存中取, 存在则直接返回, 不重复添加. 否则就搜索添加
            if (loadResource == null) {
                try {
                    AssetManager assetManager = AssetManager.class.newInstance();//创建AssetManager实例
                    Class cls = AssetManager.class;
                    Method method = cls.getMethod("addAssetPath", String.class);
                    method.setAccessible(true);
                    method.invoke(assetManager, resourcePath);//反射设置资源加载路径
                    Resources resources = new Resources(assetManager, mContext.getResources().getDisplayMetrics(),
                            mContext.getResources().getConfiguration());//构造出正确的Resource
                    loadResource = new ResourcesPlugin();
                    loadResource.resources = resources;
                    loadResource.packageName = mPackageInfo.packageName;
                    loadResource.classLoader = new DexClassLoader(resourcePath, mPluginDir, null,
                            mContext.getClassLoader());//设置正确的类加载器, 因为需要去加载R文件
                    //mResources.put(mPackageInfo.packageName, loadResource);//缓存
                    Log.w(TAG, "build resource:" + resourcePath);
                    CommonPreference.getInstance().putBoolean("resource_need_update", true);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Log.w(TAG, "load resource:" + resourcePath);
        return loadResource;
    }

    /*
    public XmlResourceParser getLayout(String packageName, String fieldName) {
        XmlResourceParser str = null;
        int resourceID = getResourceId(packageName, "layout", fieldName);
        ResourcesPlugin resource = getUnInstalledResource(packageName);
        if (resource != null) {
            try {
                str = resource.resources.getLayout(resourceID);
            } catch (Exception e) {
            }
        }
        return str;
    }

    public int getResourceId(String packageName, String type, String fieldName) {
        int resID = 0;
        ResourcesPlugin resource = getUnInstalledResource(packageName);
        String rClassName = packageName + ".R$" + type;
        Log.w(TAG, "resource class:" + rClassName + ",fieldName:" + fieldName);
        try {
            resID = resource.resources.getIdentifier(fieldName, type, packageName);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return resID;
    }

    public ResourcesPlugin getUnInstalledResource(String packageName) {
        ResourcesPlugin loadResource = mResources.get(packageName);
        if (loadResource == null) {
            Log.w(TAG, "resource " + packageName + " not founded");
        }
        return loadResource;
    }
     */

    private PackageInfo queryPackageInfo(String resourcePath) {
        return mContext.getPackageManager().getPackageArchiveInfo(resourcePath, PackageManager.GET_ACTIVITIES);
    }

    /********************************************************************/
    public String getText(String stringName) {
        int resId;
        if (TextUtils.isEmpty(stringName)) {
            return null;
        }
        if (mPluginResources != null && mPluginResources.resources != null) {
            resId = mPluginResources.resources.getIdentifier(stringName, "string", mPackageInfo.packageName);
            if (resId > 0) {
                try {
                    return mPluginResources.resources.getString(resId);
                } catch (Resources.NotFoundException e) {
                }
            }
        }
        return null;
    }
}