package com.cv.media.c.processor;


import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

import com.cv.media.lib.anotation.BindView;
import com.cv.media.lib.anotation.ViewCallback;

/**
 * MVP的注解处理
 */
@AutoService(Processor.class)
public class MVPProcessor extends AbstractProcessor {
    private final String packagePrefix = "com.cv.media.lib.mvx.mvp";
    Elements mElementUtil;
    Filer mFiler;
    Types mTypes;
    Messager mMessager;
    HashMap<String, String> mClzV_ClzP = new HashMap<>();
    String moduleName = "";
    int moduleNum = 0;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        mElementUtil = processingEnvironment.getElementUtils();
        mFiler = processingEnvironment.getFiler();
        mTypes = processingEnvironment.getTypeUtils();
        mMessager = processingEnvironment.getMessager();
        moduleName = processingEnvironment.getOptions().get("MVP_MODULE_NAME");
        mMessager.printMessage(Diagnostic.Kind.NOTE, "MVPProcessor:>>>init: " + moduleName + "  ++++------------");

        if (moduleName == null || moduleName.length() == 0)
            throw new RuntimeException("MVPProcessor:>>> 没有配置MVP_MODULE_NAME");
//        FileLock lock = null;
//        final String parentDir = ".\\build";
//        new File(parentDir).mkdir();
//        try (FileChannel channel = new FileOutputStream(parentDir + "\\tmpNum.lock", true).getChannel()) {
//            lock = channel.lock();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//        File f = new File(parentDir + "\\tmpNum");
//        if (f.exists()) {
//            try {
//                ObjectInputStream inputStream = new ObjectInputStream(new FileInputStream(f));
//                moduleNum = inputStream.readInt();
//                inputStream.close();
//            } catch (Exception e) {
//                e.printStackTrace();
//            }
//        }
//
//        try {
//            if (!f.getParentFile().exists()) f.getParentFile().mkdirs();
//            ObjectOutputStream outputStream = new ObjectOutputStream(new FileOutputStream(f));
//            outputStream.writeInt(moduleNum + 1);
//            outputStream.close();
//        } catch (Exception e) {
//            e.printStackTrace();
//        }
//
//        try {
//            if (lock != null) lock.release();
//        } catch (Exception e) {
//            if (e instanceof ClosedChannelException) {
//                return;
//            }
//            e.printStackTrace();
//        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> sets = new HashSet<>();
        sets.add(BindView.class.getCanonicalName());
        sets.add(ViewCallback.class.getCanonicalName());
        return sets;
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        long start = System.currentTimeMillis();
        makeMapsFor_P_V(roundEnvironment);
        makeMapsFor_View_Funcs(roundEnvironment);
        mMessager.printMessage(Diagnostic.Kind.NOTE, getClass().getSimpleName() + "  " + moduleName + "花费时间: " + (System.currentTimeMillis() - start) + " 毫秒" + "  ++++------------");
        return true;
    }


    /**
     * 获取View的接口
     */
    private String getV_FromP(Element element) {
        if (isElementInstanceOfClass(element, ElementKind.CLASS, packagePrefix + ".BasePresenter")) {
            try {
                BindView bindView = element.getAnnotation(BindView.class);
                Class clz = bindView.value();
                return clz.getName();
            } catch (MirroredTypeException e) {
                return e.getTypeMirror().toString();
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }

    private void makeMapsFor_P_V(RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(BindView.class)) {
            String clzName_View = getV_FromP(element);
            if (clzName_View != null)
                mClzV_ClzP.put(clzName_View, ((TypeElement) element).getQualifiedName().toString());
        }

        final String strParamMap = "map";
        MethodSpec.Builder mBuilder2 = MethodSpec.methodBuilder("fill")
                .addModifiers(Modifier.PUBLIC).
                        addParameter(ParameterSpec.builder(ParameterizedTypeName.get(ClassName.bestGuess(HashMap.class.getName()),
                                ParameterizedTypeName.get(ClassName.bestGuess(Class.class.getName()),
                                        WildcardTypeName.subtypeOf(ClassName.bestGuess(packagePrefix + ".BaseViewInterface"))),
                                ParameterizedTypeName.get(ClassName.bestGuess(Class.class.getName()),
                                        WildcardTypeName.subtypeOf(ClassName.bestGuess(packagePrefix + ".BasePresenter")))),
                                strParamMap)
                                .build()).returns(TypeName.VOID);
        mBuilder2.beginControlFlow("try");
        for (String key : mClzV_ClzP.keySet()) {
            mBuilder2.addStatement("$N.put($L.class, $L.class)", strParamMap, key, mClzV_ClzP.get(key));
        }
        mBuilder2.endControlFlow().beginControlFlow("catch($T e)", Exception.class).endControlFlow();
        TypeSpec bridge = TypeSpec.classBuilder("MVPInfoFillerImpl_" + moduleName)
                .addModifiers(Modifier.FINAL).addModifiers(Modifier.PUBLIC)
                .addJavadoc("Presenter和View的对应关系")
                .addSuperinterface(ClassName.bestGuess(packagePrefix + ".MVPInfoFiller"))
                .addMethod(mBuilder2.build()).build();
        try {
            JavaFile file = JavaFile.builder(packagePrefix, bridge).build();
            file.writeTo(mFiler);
        } catch (Exception e) {
            e.printStackTrace();
            // e.printStackTrace();
        }
    }

    private final HashMap<String, ArrayList<String>> mClzV_Funcs = new HashMap<>();

    private void makeMapsFor_View_Funcs(RoundEnvironment roundEnvironment) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(ViewCallback.class)) {
            if (element.getKind() == ElementKind.METHOD) {
                ExecutableElement executableElement = (ExecutableElement) element;
                TypeElement viewElement = (TypeElement) executableElement.getEnclosingElement();
                String viewClz = viewElement.getQualifiedName().toString();

                if (!mClzV_Funcs.containsKey(viewClz)) {
                    ArrayList<String> funs = new ArrayList<>();
                    mClzV_Funcs.put(viewClz, funs);
                }
                mClzV_Funcs.get(viewClz).add(executableElement.getSimpleName().toString());
            }
        }

        for (Map.Entry<String, ArrayList<String>> entry : mClzV_Funcs.entrySet()) {
            String viewClz = entry.getKey();
            TypeElement typeEle = mElementUtil.getTypeElement(viewClz);
            ArrayList<String> viewFuns = entry.getValue();
            TypeSpec.Builder bBuilder = TypeSpec.classBuilder(typeEle.getSimpleName() + "_ViewCallBack")
                    .addModifiers(Modifier.FINAL).addModifiers(Modifier.PUBLIC)
                    .addJavadoc(viewClz + " 的ViewCallback方法");

            for (String func : viewFuns) {
                bBuilder.addField(FieldSpec.builder(ClassName.bestGuess("String"), func, Modifier.STATIC, Modifier.FINAL, Modifier.PUBLIC).initializer("$S", func).build());
            }

            try {
                JavaFile file = JavaFile.builder(mElementUtil.getPackageOf(typeEle).getQualifiedName().toString(), bBuilder.build()).build();
                file.writeTo(mFiler);
            } catch (Exception e) {
                e.printStackTrace();
                // e.printStackTrace();
            }
        }
    }


    private TypeElement getTypeElement_V(Element element) {
        return isElementInstanceOfClass(element, ElementKind.INTERFACE, packagePrefix + ".BaseViewInterface") ? ((TypeElement) element) : null;
    }

    private boolean isElementInstanceOfClass(Element element, ElementKind kind, String baseClassQualifiedName) {
        if (element.getKind() == kind) {
            TypeElement typeElement = (TypeElement) element;
            boolean isElementInstanceOfBaseClass = false;
            TypeElement tmpTypeElement = typeElement;
            do {
                String classQualifiedName = tmpTypeElement.getQualifiedName().toString();
                if (classQualifiedName.equals(baseClassQualifiedName)) {
                    isElementInstanceOfBaseClass = true;
                    break;
                }
                if (tmpTypeElement.getSuperclass() == null) {
                    break;
                }
                tmpTypeElement = (TypeElement) mTypes.asElement(tmpTypeElement.getSuperclass());
            } while (tmpTypeElement != null);
            return isElementInstanceOfBaseClass;
        }
        return false;
    }

}

