package com.cv.media.lib.projectpipeline;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.File;
import java.util.Arrays;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;


public class Main {
    public static void main(String[] args) {
        try {
            args = new String[]{"./lib_project_pipeline/configurationTest.xml"};
            String configFileName;
            if (args.length == 0 || (configFileName = args[0]) == null || configFileName.isEmpty()) {
                throw new RuntimeException("缺少参数: 配置文件路径");
            }

            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document document = db.parse(configFileName);
                NodeList nodeList = document.getChildNodes();
                if (nodeList.getLength() == 0) {
                    throw new RuntimeException("缺少根节点");
                }
                Node root = nodeList.item(0);
                if(!root.getNodeName().equals("root")) {
                    throw new RuntimeException("根节点需为<root>");
                }

                NodeList rootChildList = root.getChildNodes();
                ValidProjects projects = new ValidProjects();
                List<ConfigurationNode> configurations = Arrays.asList(
                        new ValidProjects()
                );
                for (int i = 0; i < rootChildList.getLength(); i++) {
                    Node childNode = rootChildList.item(i);
                    if (childNode.getNodeName().equals("projects")) {
                        projects.handle(childNode);
                    }else if (childNode.getNodeName().equals("app")) {

                    }
                }
                nodeList.toString();
            } catch (Exception e) {
                throw new RuntimeException("xml解析失败");
            }
        }catch (Exception e) {
            System.out.print(e.getMessage());
        }
//        System.out.print("this is msg from Main.main");
//        File settingFile = new File("./setting.gradle");
    }


}