package com.cv.media.lib.projectpipeline;

import org.w3c.dom.Node;

import java.util.ArrayList;
import java.util.List;

public class AppConfig extends ConfigurationNode {
    String appId;
    String versionCode;
    String versionName;
    String signFilePath;
    String keyAlias;
    String keyPassword;
    String storePassword;
    final List<String> channel = new ArrayList<>();

    @Override
    String nodeName() {
        return "app";
    }

    @Override
    void onHandle(String tag, String name, String value, Node node) {
        if (tag.equals("release")) {
            traversalNode(node, (tag1, name1, value1, node1) -> {
                if (tag1.equals("sign")) {
                    handleSignNode(node1);
                } else if (tag1.equals("channels")) {
                    handleChannelsNode(node1);
                }
            });
        } else {
            switch (name) {
                case "applicationId":
                    appId = value;
                    break;
                case "versionCode":
                    versionCode = value;
                    break;
                case "versionName":
                    versionName = value;
                    break;
            }
        }
    }


    public void handleSignNode(Node node) {
        traversalNode(node, (tag, name, value, node1) -> {
            switch (name) {
                case "signFilePath":
                    signFilePath = value;
                    break;
                case "keyAlias":
                    keyAlias = value;
                    break;
                case "keyPassword":
                    keyPassword = value;
                    break;
                case "storePassword":
                    storePassword = value;
                    break;
            }
        });
    }

    public void handleChannelsNode(Node node) {
        traversalNode(node, (tag, name, value, node1) -> channel.add(value));
    }
}
