package com.cv.media.lib.projectpipeline;

import org.w3c.dom.Node;

import java.io.File;

public class PackageConfig extends ConfigurationNode {
    boolean uploadToGoogleStore;
    File resPkgLoader;
    File resPkg;

    @Override
    String nodeName() {
        return "package";
    }

    @Override
    void onHandle(String tag, String name, String value, Node node) {
        switch (name) {
            case "resourcePkg":
                resPkg = new File(value);
                break;
            case "resourcePkgLoader":
                resPkgLoader = new File(value);
                break;
            case "googleStore":
                uploadToGoogleStore = value.equals("true");
                break;
        }
    }
}
