package com.cv.media.lib.projectpipeline;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class ConfigurationNode {

    abstract String nodeName();

    final boolean handle(Node node) {
        if (!node.getNodeName().equals(nodeName())) return false;
        traversalNode(node, this::onHandle);
        return true;
    }

    protected final void traversalNode(Node node, ICallback callback) {
        if (callback == null) return;
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); i++) {
            Node n = nodeList.item(i);
            if (n.getNodeName().equals("#text")) continue;
            String tag = n.getNodeName();
            String name = n.getAttributes() == null || n.getAttributes().getNamedItem("name") == null ? "" : n.getAttributes().getNamedItem("name").getNodeValue();
            String value = n.getTextContent();
            callback.onEach(tag, name, value, n);
        }
    }

    abstract void onHandle(String tag, String name, String value, Node node);

    interface ICallback {
        void onEach(String tag, String name, String value, Node node);
    }
}
