//
// Source code recreated from a .class file by IntelliJ IDEA
// (powered by FernFlower decompiler)
//

package com.cv.media.lib.push;

import android.os.Handler;
import android.os.Looper;

import com.cv.media.lib.common_utils.async.ThreadsBox;
import com.cv.media.lib.common_utils.rxjava.StreamController;
import com.google.common.base.Joiner;
import com.google.protobuf.InvalidProtocolBufferException;

import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

import java.util.List;

import common.sdk.client.IMqttFilePersistence;
import common.sdk.model.ServerPushMessage;
import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;

class PushMqttClient implements MqttCallback {
    private String CT_20230201;
    private final String appVersion;
    private final String serverUrl;
    private final String mac;
    private final String androidId;
    private final String vnoId;
    private final String brandId;
    private final String appId;
    private final String loginId;
    private final String accountId;
    private final String accountType;
    private final String language;
    private final String tokenType;
    private final String token;
    private ClientState state = ClientState.UnReady;
    private final List<String> authParams;
    private final String dir;

    private final String jointAppId;

    private final static String NOT_ALLOW_JOINT_APPID = "false";

    private boolean isClose = false;
    MqttClient mqttClient;
    StreamController<ServerPushMessage> scMsg = new StreamController<>();
    StreamController<ClientState> scState = new StreamController<>();
    Handler handler;
    Scheduler schedule;

    static {
        LoggerFactory.setLogger(PushMqttLogger.class.getName());
    }

    {
        Looper lp = ThreadsBox.getNewHandlerThread("PushMqttClient").getLooper();
        schedule = AndroidSchedulers.from(lp);
        handler = new Handler(lp);
    }

    public PushMqttClient(String url, String mac, String androidId, String vnoId, String brandId, String appId, String appVersion, String loginId, String accountId, String accountType, String language, String tokenType, String token, List<String> authParams, String dir, String jointAppId) {
        this.serverUrl = url;
        this.mac = mac;
        this.androidId = androidId;
        this.vnoId = vnoId;
        this.brandId = brandId;
        this.appId = appId;
        this.appVersion = appVersion;
        this.loginId = loginId;
        this.accountId = accountId;
        this.accountType = accountType;
        this.language = language;
        this.tokenType = tokenType;
        this.token = token;
        this.authParams = authParams;
        this.dir = dir;
        this.jointAppId = jointAppId;
    }

    public void setState(ClientState state) {
        if (!this.state.equals(state)) {
            PusherManager.getInstance().log(PushMqttClient.this + " state change:" + state);
            scState.push(state);
        }
        this.state = state;
    }

    public void createClient() {
        PusherManager.getInstance().log(PushMqttClient.this + " createClient");
        if (mqttClient != null) {
            close(false);
        }

        try {
            PusherManager.getInstance().log(PushMqttClient.this + " create instance");
            mqttClient = new MqttClient(serverUrl, myClientId(), new IMqttFilePersistence(dir));
            mqttClient.setCallback(this);
            PusherManager.getInstance().log(PushMqttClient.this + " create instance done");
        } catch (MqttException e) {
            PusherManager.getInstance().log(PushMqttClient.this + " create instance fail:" + e.getMessage());
            e.printStackTrace();
            connectionLost(e);
        }
    }

    private String myClientId() {
        if (NOT_ALLOW_JOINT_APPID.equals(jointAppId)){
            return Joiner.on("/").useForNull("").join(mac, androidId);
        }

        return Joiner.on("/").useForNull("").join(appId, mac, androidId);
    }

    private String myPassword() {
        return Joiner.on("/").useForNull("").join(tokenType, token, authParams);
    }

    private String myUserName() {
        return Joiner.on("/").useForNull("").join(vnoId, brandId, appId, loginId, accountId, accountType, language, appVersion);
    }

    public Observable<ServerPushMessage> connect() {
        reconnectRb.run();
        return scMsg.stream().observeOn(schedule);
    }

    public Observable<ClientState> watchState() {
        return scState.stream().observeOn(schedule).startWith(state);
    }

    public void close(boolean forever) {
        PusherManager.getInstance().log(PushMqttClient.this + " start to close");
        try {
            handler.removeCallbacks(reconnectRb);
            mqttClient.setCallback(null);
            try {
                mqttClient.disconnect();
                PusherManager.getInstance().log(PushMqttClient.this + " disconnect done");
            } catch (Exception e) {
                PusherManager.getInstance().log(PushMqttClient.this + " not need to disconnect: " + e.getMessage());
            }
            mqttClient.close();
            mqttClient = null;
            PusherManager.getInstance().log(PushMqttClient.this + " close done");
            setState(ClientState.UnReady);
        } catch (MqttException e) {
            e.printStackTrace();
            PusherManager.getInstance().log(PushMqttClient.this + " close fail: " + e.getMessage());
        } finally {
            if (forever) isClose = true;
        }
    }

    private void connectInternal() throws Exception {
        PusherManager.getInstance().log(PushMqttClient.this + " connect");
        MqttConnectOptions connectOptions = new MqttConnectOptions();
        connectOptions.setUserName(myUserName());
        connectOptions.setPassword(myPassword().toCharArray());
        connectOptions.setMqttVersion(4);
        connectOptions.setAutomaticReconnect(false);
        connectOptions.setCleanSession(false);
        connectOptions.setConnectionTimeout(10);  //
        connectOptions.setKeepAliveInterval(20);   //心跳包间隔
        createClient();
        if (mqttClient == null) return;
        IMqttToken token = mqttClient.connectWithResult(connectOptions);
        if (token.getException() != null) {
            PusherManager.getInstance().log(PushMqttClient.this + " connect fail:" + token.getException().getMessage());
            throw token.getException();
        }
        PusherManager.getInstance().log(PushMqttClient.this + " connect done");
        setState(ClientState.Ready);
    }

    Runnable reconnectRb = () -> {
        try {
            connectInternal();
        } catch (Exception e) {
            connectionLost(e);
        }
    };

    @Override
    public void connectionLost(Throwable cause) {
        setState(ClientState.UnReady);
        if (isClose) {
            PusherManager.getInstance().log(PushMqttClient.this + " ignore connection lost cause by client closed");
            if (mqttClient != null) close(true);
            return;
        }
        handler.removeCallbacks(reconnectRb);
        int RECONNECT_WAIT_TIME_S = 5;
        PusherManager.getInstance().log(PushMqttClient.this + " reconnect after" + RECONNECT_WAIT_TIME_S + "s, cause connectionLost:" + cause.getMessage());
        handler.postDelayed(reconnectRb, RECONNECT_WAIT_TIME_S * 1000);
    }

    @Override
    public void messageArrived(String topic, MqttMessage message) {
        try {
            PusherManager.getInstance().log(PushMqttClient.this + " messageArrived topic:" + topic + " payload:" + message.toString());
            scMsg.push(ServerPushMessage.parseFrom(message.getPayload()));
        } catch (InvalidProtocolBufferException var5) {
            var5.printStackTrace();
        }
    }

    @Override
    public void deliveryComplete(IMqttDeliveryToken token) {

    }

    @Override
    public String toString() {
        return "Server: PushMqttClient[" + Integer.toHexString(hashCode()) + "]";
    }
}
