package com.cv.media.lib.push;

import android.util.Log;

import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.SimpleLogFormatter;

import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class PushMqttLogger implements Logger {
    private final String TAG = "PushMqtt";
    private String mResourceName = null;
    private String mLoggerName = null;
    private ResourceBundle mLogMessageCatalog = null;

    @Override
    public void initialise(ResourceBundle messageCatalog, String loggerID, String resourceName) {
        mLogMessageCatalog = messageCatalog;
        mLoggerName = loggerID;
        mResourceName = resourceName;
    }

    @Override
    public void setResourceName(String logContext) {
        mResourceName = logContext;
    }

    @Override
    public boolean isLoggable(int level) {
        return true;
    }

    @Override
    public void severe(String sourceClass, String sourceMethod, String msg) {

    }

    @Override
    public void severe(String sourceClass, String sourceMethod, String msg, Object[] inserts) {

    }

    @Override
    public void severe(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {

    }

    @Override
    public void warning(String sourceClass, String sourceMethod, String msg) {

    }

    @Override
    public void warning(String sourceClass, String sourceMethod, String msg, Object[] inserts) {

    }

    @Override
    public void warning(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {

    }

    @Override
    public void info(String sourceClass, String sourceMethod, String msg) {

    }

    @Override
    public void info(String sourceClass, String sourceMethod, String msg, Object[] inserts) {

    }

    @Override
    public void info(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {

    }

    @Override
    public void config(String sourceClass, String sourceMethod, String msg) {

    }

    @Override
    public void config(String sourceClass, String sourceMethod, String msg, Object[] inserts) {

    }

    @Override
    public void config(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {

    }

    @Override
    public void fine(String sourceClass, String sourceMethod, String msg) {
        trace(FINE, sourceClass, sourceMethod, msg, null, null);
    }

    @Override
    public void fine(String sourceClass, String sourceMethod, String msg, Object[] inserts) {
        trace(FINE, sourceClass, sourceMethod, msg, inserts, null);
    }

    @Override
    public void fine(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
        trace(FINE, sourceClass, sourceMethod, msg, inserts, ex);
    }

    public void trace(int level, String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {
        log(level, sourceClass, sourceMethod, msg, inserts, ex);
    }

    private String getResourceMessage(ResourceBundle messageCatalog, String msg) {
        String message;
        try {
            message = messageCatalog.getString(msg);
        } catch (MissingResourceException e) {
            // This is acceptable, simply return the given msg string.
            message = msg;
        }
        return message;
    }

    @Override
    public void finer(String sourceClass, String sourceMethod, String msg) {

    }

    @Override
    public void finer(String sourceClass, String sourceMethod, String msg, Object[] inserts) {

    }

    @Override
    public void finer(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {

    }

    @Override
    public void finest(String sourceClass, String sourceMethod, String msg) {

    }

    @Override
    public void finest(String sourceClass, String sourceMethod, String msg, Object[] inserts) {

    }

    @Override
    public void finest(String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable ex) {

    }
    Formatter formatter = new PushMqttLogFormatter();
    @Override
    public void log(int level, String sourceClass, String sourceMethod, String msg, Object[] inserts, Throwable thrown) {
        if (!PusherManager.getInstance().isDebug) return;

        String formattedWithArgs = msg;
        if (!msg.contains("=====")) {
            formattedWithArgs = MessageFormat.format(getResourceMessage(mLogMessageCatalog, msg), inserts);
        }
        LogRecord logRecord = new LogRecord(Level.FINE, mResourceName + ": msgKey:" + msg + " msg:" +formattedWithArgs);
        logRecord.setSourceClassName(sourceClass);
        logRecord.setSourceMethodName(sourceMethod);
        logRecord.setLoggerName(mLoggerName);
        Log.v(TAG, formatter.format(logRecord));
    }

    @Override
    public String formatMessage(String msg, Object[] inserts) {
        return null;
    }

    @Override
    public void dumpTrace() {

    }
}
