package com.cv.media.lib.push;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;

import java.util.Objects;

import io.reactivex.disposables.Disposable;

/**
 * Server point
 * 职责:
 * PushService的生命周期: 如果bind PushService的观察者没有了, 这个Service不久就会Destroy了, 进程仍然保留
 *
 * @author Damon
 */
public class PushService extends Service {
    PushServer IServer = new PushServer();
    IPushClient IClient;
    PushParam pp;

    @Override
    public IBinder onBind(Intent intent) {
        return IServer.asBinder();
    }

    @Override
    public void onCreate() {
        super.onCreate();
        PusherManager.getInstance().log("Push service create");
    }

    @Override
    public int onStartCommand(Intent intent, int flags, int startId) {
        PusherManager.getInstance().log("Push service onStartCommand");
        return super.onStartCommand(intent, flags, startId);
    }

    @Override
    public void onDestroy() {
        PusherManager.getInstance().log("Push service destroy");
        super.onDestroy();
        closeClient();
        stopSelf();
    }

    private void closeClient() {
        try {
            pmc.close(true);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            pmc = null;
        }
        if (connectDisposable != null) connectDisposable.dispose();
        if (stateDisposable != null) stateDisposable.dispose();
        connectDisposable = null;
        stateDisposable = null;
    }


    PushMqttClient pmc;
    Disposable connectDisposable;
    Disposable stateDisposable;

    class PushServer extends IPushServer.Stub {
        @Override
        public void connect(IPushClient client, PushParam param) throws RemoteException {
            IClient = client;
            IClient.asBinder().linkToDeath(new DeathRecipient() {
                @Override
                public void binderDied() {
                    PusherManager.getInstance().log("Server: client death!!!!!!!");
                    IClient.asBinder().unlinkToDeath(this, 0);
                    IClient = null;
                    if (stateDisposable != null) stateDisposable.dispose();
                    stateDisposable = null;
                }
            }, 0);
            try {
                PusherManager.getInstance().log("Server: handle connection");
                if (!Objects.equals(pp, param) && pmc != null) {
                    //pp变了, 直接关闭旧的, 开个新的重连
                    PusherManager.getInstance().log("Server: PushParam changed, close old pmc");
                    closeClient();
                }
                pp = param;
                if (pmc == null) {
                    PusherManager.getInstance().log("Server: need to new a pmc");
                    pmc = new PushMqttClient(
                            pp.brokers.get(0),
                            pp.mac,
                            pp.androidId,
                            pp.vnoId,
                            pp.brandId,
                            pp.appId,
                            pp.appVersion,
                            pp.loginId,
                            pp.accountId,
                            pp.accountType,
                            pp.language,
                            pp.tokenType,
                            pp.token,
                            pp.authParams,
                            pp.dir,
                            pp.jonitAppId);
                } else
                    PusherManager.getInstance().log("Server: still use old pmc cause everything not changed");

                if (stateDisposable == null)
                    stateDisposable = pmc.watchState().subscribe(clientState -> {
                        if (IClient != null && IClient.asBinder().isBinderAlive() && IClient.asBinder().pingBinder()) {
                            IClient.stateChange(clientState);
                        }
                    }, throwable -> PusherManager.getInstance().log("Server: push state fail:" + throwable.getMessage()));
                if (connectDisposable == null) connectDisposable = pmc.connect().subscribe(msg -> {
                    if (IClient != null && IClient.asBinder().isBinderAlive() && IClient.asBinder().pingBinder()) {
                        IClient.recvMsg(msg.getPayload().getCode(), msg.getPayload().getMsg());
                    }
                }, throwable -> PusherManager.getInstance().log("Server: push msg fail:" + throwable.getMessage()));
                PusherManager.getInstance().log("Server: handle connection done");
            } catch (Exception e) {
                PusherManager.getInstance().log("Server: handle connection fail: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }

        @Override
        public void setDebug(boolean debug) {
            PusherManager.getInstance().setDebug(debug);
        }
    }
}
