package com.cv.media.lib.push;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.cv.media.lib.common_utils.rxjava.StreamController;
import com.cv.media.lib.common_utils.utils.Singleton;

import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;

/**
 * 推送对外API
 * 目前推送服务 进程级别 只支持一对一
 *
 * @author Damon
 * description:
 */
public class PusherManager {
    private final String TAG = "Pusher";
    private static final Singleton<PusherManager> singleton = new Singleton<PusherManager>() {
        @Override
        protected PusherManager create() {
            return new PusherManager();
        }
    };


    public static PusherManager getInstance() {
        return singleton.get();
    }

    StreamController<PushMessage> scMsg = new StreamController<>();
    Pusher pusher;

    /**
     * 连接
     *
     * @param param 第一次调用, 不能为空
     *              回调环境为 主线程
     */
    public Observable<PushMessage> connect(PushParam param) {
        synchronized (PusherManager.class) {
            if (pusher == null) {
                PusherManager.getInstance().log("Pusher <init> start");
                try {
                    if (param == null)
                        throw new RuntimeException("Pusher has not started yet. $param is not allow be null");
                    PusherManager.getInstance().log("Pusher constructor invoke");
                    pusher = new Pusher(param);
                    PusherManager.getInstance().log("Pusher start invoke");
                    Disposable d = pusher.start().subscribe(pushMessage -> {
                        PusherManager.getInstance().log("Pusher rec msg:" + pushMessage);
                        scMsg.push(pushMessage);
                    }, throwable -> scMsg.error(throwable));
                    PusherManager.getInstance().log("Pusher watchState invoke");
                    PusherManager.getInstance().log("Pusher <init> done");
                } catch (Exception e) {
                    scMsg.error(e);
                    pusher = null;
                }
            }
        }
        return scMsg.stream().observeOn(AndroidSchedulers.mainThread());
    }

    public void closeConnect() {
        try {
            if (pusher != null) {
                Context context = ContextProvider.getContext();
                context.unbindService(pusher);
                pusher = null;

                // 停止服务
                Intent serviceIntent = new Intent(context, PushService.class);
                context.stopService(serviceIntent);
            }
        } catch (Throwable throwable) {
            Log.e("liao", "closeConnect ： " + throwable);
        }
    }

    /**
     * 监听Pusher的状态
     * 回调环境为 主线程
     */
    public Observable<ClientState> stateWatch() {
        return pusher != null ? pusher.watchState().observeOn(AndroidSchedulers.mainThread()) : Observable.empty();
    }

    boolean isDebug = false;

    public void setDebug(boolean debug) {
        isDebug = debug;
        if (pusher != null) pusher.setDebug(debug);
    }

    public void log(String content) {
        if (isDebug) Log.v(TAG, content);
    }
}
