package com.cv.media.lib.push;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class PushParam implements Parcelable {
    String appVersion;
    String mac;
    String androidId;
    String vnoId;
    String brandId;
    String appId;
    String loginId;
    String accountId;
    String accountType;
    String language;
    String tokenType;
    String token;
    List<String> authParams = new ArrayList<>();
    List<String> brokers = new ArrayList<>();
    String dir;
    String jonitAppId;

    public PushParam() {
    }

    protected PushParam(Parcel in) {
        appVersion = in.readString();
        mac = in.readString();
        androidId = in.readString();
        vnoId = in.readString();
        brandId = in.readString();
        appId = in.readString();
        loginId = in.readString();
        accountId = in.readString();
        accountType = in.readString();
        language = in.readString();
        tokenType = in.readString();
        token = in.readString();
        authParams = in.createStringArrayList();
        authParams = authParams == null ? new ArrayList<>() : authParams;
        brokers = in.createStringArrayList();
        brokers = brokers == null ? new ArrayList<>() : brokers;
        dir = in.readString();
        jonitAppId = in.readString();
    }

    public PushParam setMac(String mac) {
        this.mac = mac;
        return this;
    }

    public PushParam setAndroidId(String androidId) {
        this.androidId = androidId;
        return this;
    }

    public PushParam setVnoId(String vnoId) {
        this.vnoId = vnoId;
        return this;
    }

    public PushParam setBrandId(String brandId) {
        this.brandId = brandId;
        return this;
    }

    public PushParam setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public PushParam setLoginId(String loginId) {
        this.loginId = loginId;
        return this;
    }

    public PushParam setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public PushParam setAccountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    public PushParam setLanguage(String language) {
        this.language = language;
        return this;
    }

    public PushParam setTokenType(String tokenType) {
        this.tokenType = tokenType;
        return this;
    }

    public PushParam setToken(String token) {
        this.token = token;
        return this;
    }

    public PushParam addBroker(String broker) {
        brokers.add(broker);
        return this;
    }

    public PushParam setAppVersion(String appVersion) {
        this.appVersion = appVersion;
        return this;
    }

    public PushParam setJointAppId(String joint) {
        this.jonitAppId = joint;
        return this;
    }

    public String getMac() {
        return mac;
    }

    public String getAndroidId() {
        return androidId;
    }

    public String getVnoId() {
        return vnoId;
    }

    public String getBrandId() {
        return brandId;
    }

    public String getAppId() {
        return appId;
    }

    public String getLoginId() {
        return loginId;
    }

    public String getAccountId() {
        return accountId;
    }

    public String getAccountType() {
        return accountType;
    }

    public String getLanguage() {
        return language;
    }

    public String getTokenType() {
        return tokenType;
    }

    public String getToken() {
        return token;
    }

    public List<String> getAuthParams() {
        return authParams;
    }

    public List<String> getBrokers() {
        return brokers;
    }

    public String getAppVersion() {
        return appVersion;
    }

    public String getJonitAppId() {
        return jonitAppId;
    }

    public static final Creator<PushParam> CREATOR = new Creator<PushParam>() {
        @Override
        public PushParam createFromParcel(Parcel in) {
            return new PushParam(in);
        }

        @Override
        public PushParam[] newArray(int size) {
            return new PushParam[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(appVersion);
        dest.writeString(mac);
        dest.writeString(androidId);
        dest.writeString(vnoId);
        dest.writeString(brandId);
        dest.writeString(appId);
        dest.writeString(loginId);
        dest.writeString(accountId);
        dest.writeString(accountType);
        dest.writeString(language);
        dest.writeString(tokenType);
        dest.writeString(token);
        dest.writeStringList(authParams);
        dest.writeStringList(brokers);
        dest.writeString(dir);
        dest.writeString(jonitAppId);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PushParam pushParam = (PushParam) o;
        return Objects.equals(appVersion, pushParam.appVersion) && Objects.equals(mac, pushParam.mac) && Objects.equals(androidId, pushParam.androidId) && Objects.equals(vnoId, pushParam.vnoId) && Objects.equals(brandId, pushParam.brandId) && Objects.equals(appId, pushParam.appId) && Objects.equals(loginId, pushParam.loginId) && Objects.equals(accountId, pushParam.accountId) && Objects.equals(accountType, pushParam.accountType) && Objects.equals(language, pushParam.language) && Objects.equals(tokenType, pushParam.tokenType) && Objects.equals(token, pushParam.token) && Objects.equals(authParams, pushParam.authParams) && Objects.equals(brokers, pushParam.brokers) && Objects.equals(dir, pushParam.dir) && Objects.equals(jonitAppId, pushParam.jonitAppId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(appVersion, mac, androidId, vnoId, brandId, appId, loginId, accountId, accountType, language, tokenType, token, authParams, brokers, dir, jonitAppId);
    }
}
