package com.cv.media.lib.push;

import android.os.Parcel;
import android.os.Parcelable;

import java.util.Objects;

public class ClientState implements Parcelable {
    public static final ClientState Ready = new ClientState(0);
    public static final ClientState UnReady = new ClientState(1);

    private final int value;

    private ClientState(int value) {
        this.value = value;
    }

    protected ClientState(Parcel in) {
        value = in.readInt();
    }

    public static final Creator<ClientState> CREATOR = new Creator<ClientState>() {
        @Override
        public ClientState createFromParcel(Parcel in) {
            return new ClientState(in);
        }

        @Override
        public ClientState[] newArray(int size) {
            return new ClientState[size];
        }
    };

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(value);
    }

    @Override
    public String toString() {
        return "ClientState[" + (value == 0 ? "Ready" : "unReady") + ']';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ClientState that = (ClientState) o;
        return value == that.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }
}
