package com.cv.media.lib.share;

import android.content.Context;
import android.net.Uri;
import com.cv.media.lib.common_utils.provider.ContextProvider;

/**
 * Created by Joyce.wang on 2023/4/18.
 */
public class ShareManager {
    private static final String TAG = ShareManager.class.getSimpleName();
    private volatile static ShareManager instance;
    private Context context;

    private ShareManager(Context context) {
        this.context = context;
    }

    public static ShareManager getInstance() {
        if (null == instance) {
            synchronized (ShareManager.class) {
                if (instance == null) {
                    instance = new ShareManager(ContextProvider.getApplication());
                }
            }
        }
        return instance;
    }

    public Uri createLongDynamicLink(ShareType shareType, ShareInfo shareInfo) {
        Uri dynamicLink = null;
        if (shareInfo != null) {
            switch (shareType) {
                case AD_BANNER:
                    dynamicLink = FirebaseShareManager.getInstance().createAdBannerDynamicLink(shareInfo);
                    break;
                case STAR_DETAIL:
                    dynamicLink = FirebaseShareManager.getInstance().createStarDynamicLink(shareInfo);
                    break;
                case VIDEO_LIST:
                    dynamicLink = FirebaseShareManager.getInstance().createVideoListDynamicLink(shareInfo);
                    break;
                case VIDEO_DETAIL:
                    dynamicLink = FirebaseShareManager.getInstance().createVideoDetailDynamicLink(shareInfo);
                    break;
            }
        }
        return dynamicLink;
    }
}
