package com.cv.media.lib.share;

import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;

import com.google.android.gms.tasks.Task;
import com.google.firebase.dynamiclinks.DynamicLink;
import com.google.firebase.dynamiclinks.FirebaseDynamicLinks;
import com.google.firebase.dynamiclinks.ShortDynamicLink;

public class FirebaseShareManager {
    private static final String TAG = FirebaseShareManager.class.getSimpleName();
    private String dynamicLinkPrefix;
    private String dynamicLinkPrefixTest;
    private String defaultDeepLink;
    private String shareDeepLinkHost;
    private String flavorEnv;
    private static FirebaseShareManager instance;

    public static void init(String firebaseLinkPrefix, String defaultDeepLink, String shareDeepLinkHost, String firebaseLinkPrefixTest, String flavorEnv) {
        if (null == instance) {
            instance = new FirebaseShareManager(firebaseLinkPrefix, defaultDeepLink, shareDeepLinkHost, firebaseLinkPrefixTest, flavorEnv);
        }
    }

    public static FirebaseShareManager getInstance() {
        if (instance == null) {
            throw new RuntimeException(FirebaseShareManager.class.getSimpleName() + " not instantiated");
        }
        return instance;
    }

    private FirebaseShareManager(String firebaseLinkPrefix, String defaultDeepLink, String shareDeepLinkHost, String firebaseLinkPrefixTest, String flavorEnv) {
        this.dynamicLinkPrefix = firebaseLinkPrefix;
        this.defaultDeepLink = defaultDeepLink;
        this.shareDeepLinkHost = shareDeepLinkHost;
        this.dynamicLinkPrefixTest = firebaseLinkPrefixTest;
        this.flavorEnv = flavorEnv;
    }

    public Uri createStarDynamicLink(ShareInfo shareInfo) {
        if (shareInfo != null) {
            String depthLink = getDeepLink() + "?type=" + ShareType.STAR_DETAIL + "&extra=" + shareInfo.getPersonId();
            return createDynamicLink(shareInfo, depthLink);
        }
        return null;
    }

    public Uri createAdBannerDynamicLink(ShareInfo shareInfo) {
        if (shareInfo != null) {
            String depthLink = getDeepLink() + "?type=" + ShareType.AD_BANNER + "&extra=" + shareInfo.getAdBannerUrl();
            return createDynamicLink(shareInfo, depthLink);
        }
        return null;
    }

    public Uri createVideoDetailDynamicLink(ShareInfo shareInfo) {
        if (shareInfo != null) {
            String depthLink = getDeepLink() + "?type=" + ShareType.VIDEO_DETAIL
                    + "&extra=" + shareInfo.getVideoID()
                    + "&extra1=" + shareInfo.getImdbId();
            return createDynamicLink(shareInfo, depthLink);
        }
        return null;
    }

    public Uri createVideoListDynamicLink(ShareInfo shareInfo) {
        if (shareInfo != null) {
            String depthLink = getDeepLink() + "?type=" + ShareType.VIDEO_LIST
                    + "&extra=" + shareInfo.getPlayListId()
                    + "&extra1=" + shareInfo.getPlayListName()
                    + "&extra2=" + shareInfo.getHomePage()
                    + "&extra3=" + shareInfo.getPlayListLayout();
            return createDynamicLink(shareInfo, depthLink);
        }
        return null;
    }

    public Uri createCustomListDynamicLink(ShareInfo shareInfo) {
        if (shareInfo != null) {
            String depthLink = getDeepLink() + "?type=" + ShareType.CUSTOM_LIST
                    + "&extra=" + shareInfo.getPlayListId()
                    + "&extra1=" + shareInfo.getPlayListName();
            return createDynamicLink(shareInfo, depthLink);
        }
        return null;
    }

    private Uri createDynamicLink(ShareInfo shareInfo, String depthLink) {
        if (shareInfo != null) {
            Log.v("ShareInfo_Title", "ShareInfo_title:_" + shareInfo.getShareTitle());
            Log.v("ShareInfo_ImageUrl", "ShareInfo_ImageUrl:_" + shareInfo.getShareImageUrl());
            if (TextUtils.isEmpty(shareInfo.getShareTitle()) || TextUtils.isEmpty(shareInfo.getShareImageUrl())) {
                DynamicLink dynamicLink = FirebaseDynamicLinks.getInstance().createDynamicLink()
                        .setLink(Uri.parse(depthLink))
                        .setDomainUriPrefix("PROD".equalsIgnoreCase(flavorEnv) ? dynamicLinkPrefix : dynamicLinkPrefixTest)
                        .setAndroidParameters(new DynamicLink.AndroidParameters.Builder().setFallbackUrl(Uri.parse(getDeepLink())).build()).buildDynamicLink();
                Uri dynamicLinkUri = dynamicLink.getUri();
                return dynamicLinkUri;
            } else {
                DynamicLink dynamicLink = FirebaseDynamicLinks.getInstance().createDynamicLink()
                        .setLink(Uri.parse(depthLink))
                        .setDomainUriPrefix("PROD".equalsIgnoreCase(flavorEnv) ? dynamicLinkPrefix : dynamicLinkPrefixTest)
                        .setAndroidParameters(new DynamicLink.AndroidParameters.Builder().setFallbackUrl(Uri.parse(getDeepLink())).build())
                        .setSocialMetaTagParameters(new DynamicLink.SocialMetaTagParameters.Builder().setTitle(shareInfo.getShareTitle())
                                .setImageUrl(Uri.parse(shareInfo.getShareImageUrl()))
                                .setDescription(shareInfo.getShareDescription()).build())
                        .buildDynamicLink();
                Uri dynamicLinkUri = dynamicLink.getUri();
                return dynamicLinkUri;
            }
        }
        return null;
    }

    public Task<ShortDynamicLink> createShortLink(Uri uri) {
        Task<ShortDynamicLink> shortLinkTask = FirebaseDynamicLinks.getInstance().createDynamicLink()
                .setLongLink(uri)
                .buildShortDynamicLink(ShortDynamicLink.Suffix.SHORT);
        return shortLinkTask;
    }

    private String getDeepLink() {
        if (!TextUtils.isEmpty(shareDeepLinkHost)) {
            String[] deepLink = shareDeepLinkHost.split(",");
            if (deepLink != null && deepLink.length > 0) {
                String appWebHost = deepLink[0];
                return appWebHost + "/api/uc/getLinkShare/v1";
            }
        }
        return defaultDeepLink;
    }
}
