package com.cv.media.c.speed_test;

import android.content.Context;

import com.cv.media.c.speed_test.ookla.OoklaSpeedTestManager;
import com.cv.media.c.speed_test.valor.ValorSpeedTestManager;
import com.purple.crane.speedtest.core.TestResult;

public class SpeedTestManager {

    private static SpeedTestManager sInstance;

    public static SpeedTestManager getInstance() {
        if (sInstance == null) {
            synchronized (SpeedTestManager.class) {
                if (sInstance == null)
                    sInstance = new SpeedTestManager();
            }
        }
        return sInstance;
    }

    private OoklaSpeedTestManager mOoklaSpeedTestManager;
    private ValorSpeedTestManager mValorSpeedTestManager;

    private ValorSpeedTestManager.ValorSpeedTestCallBackListener mValorSpeedTestCallBackListener;

    public void setValorCallBackListener(ValorSpeedTestManager.ValorSpeedTestCallBackListener listener) {
        this.mValorSpeedTestCallBackListener = listener;
    }

    public void startValorNetWorkTest(String downloadFileUrl) {
        mValorSpeedTestManager = new ValorSpeedTestManager();
        mValorSpeedTestManager.setCallBackListener(new ValorSpeedTestManager.ValorSpeedTestCallBackListener() {
            @Override
            public void onProgressUpdate(ValorSpeedTestManager.ValorTestResult valorTestResult) {
                if(mValorSpeedTestCallBackListener != null) {
                    mValorSpeedTestCallBackListener.onProgressUpdate(valorTestResult);
                }
            }

            @Override
            public void onComplete() {
                if(mValorSpeedTestCallBackListener != null) {
                    mValorSpeedTestCallBackListener.onComplete();
                }
            }
        });
        mValorSpeedTestManager.startValorNetTest(downloadFileUrl);
    }

    private OoklaSpeedTestManager.OoklaSpeedTestCallBackListener mOoklaSpeedTestCallBackListener;

    public void setOoklaCallBackListener(OoklaSpeedTestManager.OoklaSpeedTestCallBackListener listener) {
        this.mOoklaSpeedTestCallBackListener = listener;
    }
    public void startOokaNetworkTest(Context context) {
        mOoklaSpeedTestManager = new OoklaSpeedTestManager();
        mOoklaSpeedTestManager.setCallBackListener(new OoklaSpeedTestManager.OoklaSpeedTestCallBackListener() {
            @Override
            public void onDownloadUpdate(TestResult testResult) {
                if(mOoklaSpeedTestCallBackListener != null) {
                    mOoklaSpeedTestCallBackListener.onDownloadUpdate(testResult);
                }
            }

            @Override
            public void onUploadUpdate(TestResult testResult) {
                if(mOoklaSpeedTestCallBackListener != null) {
                    mOoklaSpeedTestCallBackListener.onUploadUpdate(testResult);
                }
            }

            @Override
            public void onPingJitterUpdate(TestResult testResult) {
                if(mOoklaSpeedTestCallBackListener != null) {
                    mOoklaSpeedTestCallBackListener.onPingJitterUpdate(testResult);
                }
            }

            @Override
            public void onIPInfoUpdate(TestResult testResult) {
                if(mOoklaSpeedTestCallBackListener != null) {
                    mOoklaSpeedTestCallBackListener.onIPInfoUpdate(testResult);
                }
            }

            @Override
            public void onGetTestServerDone(TestResult testResult) {
                if(mOoklaSpeedTestCallBackListener != null) {
                    mOoklaSpeedTestCallBackListener.onGetTestServerDone(testResult);
                }
            }

            @Override
            public void onDone(TestResult testResult) {
                if(mOoklaSpeedTestCallBackListener != null) {
                    mOoklaSpeedTestCallBackListener.onDone(testResult);
                }
            }

            @Override
            public void onCriticalFailure(TestResult testResult) {
                if(mOoklaSpeedTestCallBackListener != null) {
                    mOoklaSpeedTestCallBackListener.onCriticalFailure(testResult);
                }
            }
        });
        mOoklaSpeedTestManager.startOoklaNetworkTest(context);
    }

    public OoklaSpeedTestManager getOoklaSpeedTestManager() {
        return mOoklaSpeedTestManager;
    }

    public ValorSpeedTestManager getValorSpeedTestManager() {
        return mValorSpeedTestManager;
    }
}
