package com.cv.media.c.speed_test.ookla;

import android.content.Context;

import com.cv.media.c.speed_test.SpeedTestManager;
import com.cv.media.c.speed_test.valor.ValorSpeedTestManager;
import com.purple.crane.speedtest.core.SpeedtestManager;
import com.purple.crane.speedtest.core.TestResult;
import com.purple.crane.speedtest.core.config.SpeedtestConfig;

public class OoklaSpeedTestManager {
    private SpeedtestManager mOoklaSpeedTestManager;

    private OoklaSpeedTestCallBackListener mOoklaSpeedTestCallBackListener;

    public void setCallBackListener(OoklaSpeedTestCallBackListener listener) {
        this.mOoklaSpeedTestCallBackListener = listener;
    }

    public void startOoklaNetworkTest(Context context) {
        if (context == null) {
            return;
        }
        if (mOoklaSpeedTestManager == null) {
            mOoklaSpeedTestManager = SpeedtestManager.getSpeedtestManager(context);
        }

        SpeedtestConfig speedtestConfig = new SpeedtestConfig();
        speedtestConfig.setTestOrder("IPDU");
        mOoklaSpeedTestManager.setSpeedtestConfig(speedtestConfig);

        mOoklaSpeedTestManager.startTest();
        mOoklaSpeedTestManager.setCallBackListener(new SpeedtestManager.SpeedtestCallBackListener() {
            @Override
            public void onDownloadUpdate(TestResult testResult) {
                mOoklaSpeedTestCallBackListener.onDownloadUpdate(testResult);
            }

            @Override
            public void onUploadUpdate(TestResult testResult) {
                mOoklaSpeedTestCallBackListener.onUploadUpdate(testResult);
            }

            @Override
            public void onPingJitterUpdate(TestResult testResult) {
                mOoklaSpeedTestCallBackListener.onPingJitterUpdate(testResult);
            }

            @Override
            public void onIPInfoUpdate(TestResult testResult) {
                mOoklaSpeedTestCallBackListener.onIPInfoUpdate(testResult);
            }

            @Override
            public void onGetTestServerDone(TestResult testResult) {
                mOoklaSpeedTestCallBackListener.onGetTestServerDone(testResult);
            }

            @Override
            public void onDone(TestResult testResult) {
                mOoklaSpeedTestCallBackListener.onDone(testResult);
            }

            @Override
            public void onCriticalFailure(TestResult testResult) {
                mOoklaSpeedTestCallBackListener.onCriticalFailure(testResult);
            }
        });
    }

    public void stopOoklaSpeedTest() {
        if (mOoklaSpeedTestManager != null) {
            mOoklaSpeedTestManager.stopTest();
        }
    }

    public interface OoklaSpeedTestCallBackListener {
        void onDownloadUpdate(TestResult testResult);
        void onUploadUpdate(TestResult testResult);
        void onPingJitterUpdate(TestResult testResult);
        void onIPInfoUpdate(TestResult testResult);
        void onGetTestServerDone(TestResult testResult);
        void onDone(TestResult testResult);
        void onCriticalFailure(TestResult testResult);
    }
}
