package com.cv.media.c.speed_test.valor;

import android.os.AsyncTask;

import com.cv.media.lib.log.Logger;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;

public class ValorSpeedTestManager {

    private static final String TAG = ValorSpeedTestManager.class.getSimpleName();
    private static final int MAX_DOWNLOAD_SIZE = 10 * 1024 * 1024;// 10MB
    private static final String SPEED_TEST_URL_DEFAULT = "http://speedtest.fremont.linode.com/100MB-fremont.bin";

    private boolean isStopped = false;
    private String downloadFileUrl = SPEED_TEST_URL_DEFAULT;

    private ValorTestResult mValorTestResult;
    private ValorSpeedTestCallBackListener mValorSpeedTestCallBackListener;

    public void setCallBackListener(ValorSpeedTestCallBackListener listener) {
        this.mValorSpeedTestCallBackListener = listener;
    }

    public void startValorNetTest(String downloadFileUrl) {
        if (mValorTestResult == null) {
            mValorTestResult = new ValorTestResult();
        }
        mValorTestResult.init();
        new DownloadAsyncTask().execute(downloadFileUrl);
    }

    public void setIsStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public void stopValorSpeedTest() {
        this.isStopped = true;
    }

    private class DownloadAsyncTask extends AsyncTask<String, Long, String> {
        private static final long MILI_TO_NANO = 1_000_000;
        private SpeedInfo speedInfo = new SpeedInfo();

        @Override
        protected String doInBackground(String... urls) {
            String urlStr = urls[0];
            InputStream stream = null;
            URLConnection connection = null;
            int cacheBytes = 1024;
            long refreshInterval = 1_000_000_000L;
            byte[] recvBytes = new byte[cacheBytes];
            try {
                int currentByte = 0;
                long startConTime = System.nanoTime();
                URL url = new URL(urlStr);
                connection = url.openConnection();
                connection.setUseCaches(false);
                long connectionLatency = (System.nanoTime() - startConTime) / MILI_TO_NANO;
                Logger.d(TAG, "Connection latency = " + connectionLatency + "");
                connection.setConnectTimeout(20000);
                connection.setReadTimeout(20000);
                stream = connection.getInputStream();
                //总字节数
                speedInfo.totalBytes = Math.min(connection.getContentLength(), MAX_DOWNLOAD_SIZE);
                //开始下载时间
                speedInfo.startDldTime = System.nanoTime();
                //上次下载时间
                speedInfo.lastDldTime = speedInfo.startDldTime;
                speedInfo.lastDldBytes = 0;
                //每次下载大小
                while ((currentByte = stream.read(recvBytes)) != -1) {
                    //最新下载时间
                    speedInfo.newDldTime = System.nanoTime();
                    //完成字节数
                    speedInfo.finishedBytes += currentByte;
                    //本次完成字节数
                    speedInfo.lastDldBytes += currentByte;
                    //到达更新时间
                    if (speedInfo.newDldTime - speedInfo.lastDldTime >= refreshInterval || speedInfo.finishedBytes >= speedInfo.totalBytes) {
                        //更新视图
                        publishProgress(speedInfo.calc());
                        //重置本次下载大小
                        speedInfo.lastDldBytes = 0;
                        //重置上次下载时间
                        speedInfo.lastDldTime = speedInfo.newDldTime;
                    }
                    Logger.d(TAG, "download test finished bytes:" + speedInfo.finishedBytes);

                    if (speedInfo.finishedBytes >= speedInfo.totalBytes || isStopped) break;
                }

            } catch (MalformedURLException e) {
                Logger.e(TAG, "MalformedURLException,test download exception" + e.getMessage());
            } catch (IOException e) {
                Logger.e(TAG, "IOException,test download exception" + e.getMessage());
            } finally {
                if (stream != null) {
                    try {
                        stream.close();
                    } catch (IOException ignored) {
                    }
                }
            }
            return "done";
        }

        @Override
        protected void onProgressUpdate(Long... values) {
            super.onProgressUpdate(values);
            Logger.i(TAG, "onProgressUpdate values:" + values[0] + " " + values[1] + " " + values[2] + " " + values[3] + " " + values[4] + " " + values[5]);
            //current speed KB/S
            if (values[4] == 0L) {
                mValorTestResult.setCurrentSpeed(1000);
            } else {
                mValorTestResult.setCurrentSpeed(values[5] / 1024.0 / values[4] * 1000000000.0);
            }
            //average speed KB/S
            mValorTestResult.setAverageSpeed(values[1] / 1024.0 / (values[3] - values[2]) * 1000000000.0);
            int percent = (int) (1.0 * values[1] / values[0] * 100);
            mValorTestResult.setPercent(percent > 100 ? 100 : percent);
            mValorSpeedTestCallBackListener.onProgressUpdate(mValorTestResult);
        }

        @Override
        protected void onPostExecute(String s) {
            super.onPostExecute(s);
            mValorSpeedTestCallBackListener.onComplete();
        }
    }

    private static class SpeedInfo {
        public int finishedBytes = 0;
        public int totalBytes = 0;
        public int finishedPercent = 0;
        public long startDldTime = 0l;
        public long lastDldTime = 0l;
        public long newDldTime = 0l;
        public int lastDldBytes = 1;
        public Long[] result = new Long[10];

        public Long[] calc() {
            //总大小
            result[0] = (long) this.totalBytes;
            //已完成大小
            result[1] = (long) this.finishedBytes;
            //下载开始时间
            result[2] = this.startDldTime;
            //当前时间
            result[3] = this.newDldTime;
            //区间大小
            result[4] = this.newDldTime - this.lastDldTime;
            //区间下载大小
            result[5] = (long) lastDldBytes;
            return result;
        }
    }

    public class ValorTestResult {
        private int percent;
        private double averageSpeed;
        private double currentSpeed;

        public int getPercent() {
            return percent;
        }

        public void setPercent(int percent) {
            this.percent = percent;
        }

        public double getAverageSpeed() {
            return averageSpeed;
        }

        public void setAverageSpeed(double averageSpeed) {
            this.averageSpeed = averageSpeed;
        }

        public double getCurrentSpeed() {
            return currentSpeed;
        }

        public void setCurrentSpeed(double currentSpeed) {
            this.currentSpeed = currentSpeed;
        }

        public void init() {
            percent = 0;
            averageSpeed = 0;
            averageSpeed = 0;
        }
    }

    private String format2Digits(double d) {
        NumberFormat ddf1 = NumberFormat.getNumberInstance();
        ddf1.setMaximumFractionDigits(2);
        return ddf1.format(d);
    }

    public interface ValorSpeedTestCallBackListener {
        void onProgressUpdate(ValorTestResult valorTestResult);
        void onComplete();
    }
}
