package com.cv.media.lib.storage.sp;

import android.content.Context;
import android.util.Log;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.cv.media.lib.common_utils.crypto.AESCodecAndroid;

import net.grandcentrix.tray.provider.ContentProviderStorage;

/**
 * Created by elegant.wang on 2016/8/9.
 */
public class CipherContentProviderStorage extends ContentProviderStorage {
    private static final String TAG = CipherContentProviderStorage.class.getCanonicalName();
    private String cipherKey;

    public CipherContentProviderStorage(@NonNull Context context, @NonNull String module, @NonNull Type type, String cipherKey) {
        super(context, module, type);
        this.cipherKey = cipherKey;
    }

    @Override
    public void put(@NonNull String key, @Nullable String migrationKey, @Nullable Object data) {
        if (data == null) {
            super.put(key, migrationKey, null);
            return;
        }
        if (data instanceof String || data instanceof Integer || data instanceof Long || data instanceof Float || data instanceof Boolean || data instanceof Double) {
            String value = String.valueOf(data);
            String newValue;
            try {
                newValue = AESCodecAndroid.encrypt(value, cipherKey);
            } catch (Exception e) {
                Log.e(TAG, "put error,use original value");
                newValue = value;
            }
            super.put(key, migrationKey, newValue);
        } else {
            super.put(key, migrationKey, data);
        }
    }
}
