package com.cv.media.lib.storage.mmkv;

public abstract class Preference implements IPreference {
    IPreference perfImpl;

    public void setPerfImpl(IPreference perfImpl) {
        this.perfImpl = perfImpl;
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return perfImpl.getBoolean(key, defaultValue);
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return perfImpl.getFloat(key, defaultValue);
    }

    @Override
    public int getInt(String key, int defaultValue) {
        return perfImpl.getInt(key, defaultValue);
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return perfImpl.getLong(key, defaultValue);
    }

    @Override
    public String getString(String key) {
        return perfImpl.getString(key);
    }

    @Override
    public String getString(String key, String defaultValue) {
        return perfImpl.getString(key, defaultValue);
    }

    @Override
    public void putString(String key, String value) {
        perfImpl.putString(key, value);
    }

    @Override
    public void putInt(String key, int value) {
        perfImpl.putInt(key, value);
    }

    @Override
    public void putFloat(String key, float value) {
        perfImpl.putFloat(key, value);
    }

    @Override
    public void putLong(String key, long value) {
        perfImpl.putLong(key, value);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        perfImpl.putBoolean(key, value);
    }

    @Override
    public void remove(String key) {
        perfImpl.remove(key);
    }
}
