package com.cv.media.lib.storage.sp;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

/**
 * Created by Larry on 2016/7/11.
 */
public interface UserPreferenceAccessor {

    boolean getBoolean(@NonNull final String key, final boolean defaultValue);

    float getFloat(@NonNull final String key, final float defaultValue);

    int getInt(@NonNull final String key, final int defaultValue);

    long getLong(@NonNull final String key, final long defaultValue);

    @Nullable
    String getString(@NonNull final String key);

    @Nullable
    String getString(@NonNull final String key, @Nullable final String defaultValue);

    void put(@NonNull final String key, @Nullable final String value);

    void put(@NonNull final String key, final int value);

    void put(@NonNull final String key, final float value);

    void put(@NonNull final String key, final long value);

    void put(@NonNull final String key, final boolean value);

    void remove(@NonNull final String key);
}
