package com.cv.media.lib.storage.mmkv;

import android.content.SharedPreferences;

/**
 * Created by zhangyaoa on 2022/6/27.
 */
public class NormaPreference implements IPreference {

    private SharedPreferences mSp;

    public NormaPreference(SharedPreferences sp) {
        this.mSp = sp;
    }

    @Override
    public int getInt(String key, int defValue) {
        try {
            return this.mSp.getInt(key, defValue);
        } catch (ClassCastException e) {
            return Integer.parseInt(mSp.getString(key, String.valueOf(defValue)));
        } catch (Exception e) {

        }
        return defValue;
    }

    @Override
    public long getLong(String key, long defValue) {
        try {
            return this.mSp.getLong(key, defValue);
        } catch (ClassCastException e) {
            return Long.parseLong(mSp.getString(key, String.valueOf(defValue)));
        } catch (Exception e) {

        }
        return defValue;
    }

    @Override
    public float getFloat(String key, float defValue) {
        try {
            return this.mSp.getFloat(key, defValue);
        } catch (ClassCastException e) {
            return Float.parseFloat(mSp.getString(key, String.valueOf(defValue)));
        } catch (Exception e) {

        }
        return defValue;
    }

    @Override
    public boolean getBoolean(String key, boolean defValue) {
        try {
            return this.mSp.getBoolean(key, defValue);
        } catch (ClassCastException e) {
            return Boolean.parseBoolean(mSp.getString(key, String.valueOf(defValue)));
        } catch (Exception e) {

        }
        return defValue;
    }

    @Override
    public String getString(String key) {
        return getString(key, "");
    }

    @Override
    public String getString(String key, String defaultValue) {
        try {
            return mSp.getString(key, defaultValue);
        }catch (Exception e){

        }
        return defaultValue;
    }

    @Override
    public void putString(String key, String value) {
        mSp.edit().putString(key, value).apply();
    }

    @Override
    public void putInt(String key, int value) {
        mSp.edit().putInt(key, value).apply();
    }

    @Override
    public void putFloat(String key, float value) {
        this.mSp.edit().putFloat(key, value).apply();
    }

    @Override
    public void putLong(String key, long value) {
        this.mSp.edit().putLong(key, value).apply();
    }

    @Override
    public void putBoolean(String key, boolean value) {
        this.mSp.edit().putBoolean(key, value).apply();
    }

    @Override
    public void remove(String key) {
        this.mSp.edit().remove(key).apply();
    }
}
