package com.cv.media.lib.storage.mmkv;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.cv.media.lib.storage.sp.CipherTrayPreference;

/**
 * Created by zhangyaoa on 2022/6/27.
 */
public class NormaCipherPreference implements IPreference {

    private CipherTrayPreference mTrayPreference;

    public NormaCipherPreference(CipherTrayPreference trayPreference) {
        mTrayPreference = trayPreference;
    }

    @Override
    public boolean getBoolean(@NonNull String key, boolean defaultValue) {
        boolean retValue = defaultValue;
        try {
            retValue = mTrayPreference.getBoolean(key);
        } catch (Throwable t) {
            //继续查找下一个
        }
        return retValue;
    }

    @Override
    public float getFloat(@NonNull String key, float defaultValue) {
        float retValue = defaultValue;
        try {
            retValue = mTrayPreference.getFloat(key);
        } catch (Throwable t) {
            //继续查找下一个
        }
        return retValue;
    }

    @Override
    public int getInt(@NonNull String key, int defaultValue) {
        int retValue = defaultValue;
        try {
            retValue = mTrayPreference.getInt(key);
        } catch (Throwable t) {
            //继续查找下一个
        }
        return retValue;
    }

    @Override
    public long getLong(@NonNull String key, long defaultValue) {
        long retValue = defaultValue;
        try {
            retValue = mTrayPreference.getLong(key);
        } catch (Throwable t) {
            //继续查找下一个
        }
        return retValue;
    }

    @Nullable
    @Override
    public String getString(@NonNull String key) {
        return getString(key, null);
    }

    @Nullable
    @Override
    public String getString(@NonNull String key, @Nullable String defaultValue) {
        String retValue = defaultValue;
        try {
            retValue = mTrayPreference.getString(key);
        } catch (Throwable t) {
            //继续查找下一个
        }
        return retValue;
    }


    @Override
    public void putString(String key, String value) {
        mTrayPreference.put(key, value);
    }

    @Override
    public void putInt(String key, int value) {
        mTrayPreference.put(key, value);
    }

    @Override
    public void putFloat(String key, float value) {
        mTrayPreference.put(key, value);
    }

    @Override
    public void putLong(String key, long value) {
        mTrayPreference.put(key, value);
    }

    @Override
    public void putBoolean(String key, boolean value) {
        mTrayPreference.put(key, value);
    }

    @Override
    public void remove(String key) {
        mTrayPreference.remove(key);
    }
}
