package com.cv.media.lib.storage.mmkv;


import com.tencent.mmkv.MMKV;

class MMKVPreference implements IPreference {
    MMKV mmkv;

    public MMKVPreference(MMKV kv) {
        mmkv = kv;
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(mmkv.getString(key, String.valueOf(defaultValue)));
        }catch (Exception e){
            return defaultValue;
        }
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        try {
            return Float.parseFloat(mmkv.getString(key, String.valueOf(defaultValue)));
        }catch (Exception e){
            return defaultValue;
        }
    }

    @Override
    public int getInt(String key, int defaultValue) {
        try {
            return Integer.parseInt(mmkv.getString(key, String.valueOf(defaultValue)));
        }catch (Exception e){
            return defaultValue;
        }
    }

    @Override
    public long getLong(String key, long defaultValue) {
        try {
            return Long.parseLong(mmkv.getString(key, String.valueOf(defaultValue)));
        }catch (Exception e){
            return defaultValue;
        }
    }

    @Override
    public String getString(String key) {
        return mmkv.getString(key, "");
    }

    @Override
    public String getString(String key, String defaultValue) {
        return mmkv.getString(key, defaultValue);
    }

    @Override
    public void putString(String key, String value) {
        mmkv.putString(key, value);
    }

    @Override
    public void putInt(String key, int value) {
        mmkv.putString(key, String.valueOf(value));
    }

    @Override
    public void putFloat(String key, float value) {
        mmkv.putString(key, String.valueOf(value));
    }

    @Override
    public void putLong(String key, long value) {
        mmkv.putString(key, String.valueOf(value));
    }

    @Override
    public void putBoolean(String key, boolean value) {
        mmkv.putString(key, String.valueOf(value));
    }

    @Override
    public void remove(String key) {
        mmkv.remove(key);
    }
}
