package com.cv.media.lib.storage.mmkv;

import android.content.Context;

import com.tencent.mmkv.MMKV;

import com.cv.media.lib.common_utils.libso.SoLibLoader;

/**
 * 职责:
 *
 * @author Damon
 */
class MMKVPreferenceFactory implements IPreferenceFactory {

    public MMKVPreferenceFactory(Context application) {
        MMKV.initialize(application.getFilesDir().getAbsolutePath() + "/mmkv", new MMKV.LibLoader() {
            @Override
            public void loadLibrary(String libName) {
                SoLibLoader.loadLibrary(application, libName);
            }
        });
    }

    public IPreference create(String name, String cipherStr) {
        if (name != null && !name.isEmpty()) {
            if (cipherStr != null && !cipherStr.isEmpty()) {
                return new MMKVPreference(MMKV.mmkvWithID(name, MMKV.SINGLE_PROCESS_MODE, cipherStr));
            } else {
                return new MMKVPreference(MMKV.mmkvWithID(name, MMKV.SINGLE_PROCESS_MODE));
            }
        } else {
            if (cipherStr != null && !cipherStr.isEmpty()) {
                return new MMKVPreference(MMKV.defaultMMKV(MMKV.SINGLE_PROCESS_MODE, cipherStr));
            } else {
                return new MMKVPreference(MMKV.defaultMMKV());
            }
        }
    }
}
