package com.cv.media.lib.storage.mmkv;

import com.cv.media.lib.common_utils.provider.ContextProvider;

/**
 * 正常存储使用CommonCipherPreference内部已将mmkv替换为系统sharedpreference，这里只是为了读取3.0.0数据以同步
 */

public class CommonMMKVCipherPreference extends Preference {
    private CommonMMKVCipherPreference() {
        setPerfImpl(Factory.get(ContextProvider.getContext()).create(ContextProvider.getContext().getPackageName(), "CommonCipherPreference"));
    }

    public static CommonMMKVCipherPreference getInstance() {
        return CommonMMKVCipherPreference.SingletonInnerClass.INSTANCE;
    }

    static class SingletonInnerClass {
        final static CommonMMKVCipherPreference INSTANCE = new CommonMMKVCipherPreference();
    }
}
