package com.cv.media.lib.storage.sp;

import android.content.Context;
import android.util.Log;

import androidx.annotation.NonNull;

import com.cv.media.lib.common_utils.crypto.AESCodecAndroid;

import net.grandcentrix.tray.core.AbstractTrayPreference;
import net.grandcentrix.tray.core.ItemNotFoundException;
import net.grandcentrix.tray.core.TrayItem;
import net.grandcentrix.tray.core.TrayStorage.Type;
import net.grandcentrix.tray.provider.ContentProviderStorage;

/**
 * Created by elegant.wang on 2016/8/9.
 */
public class CipherTrayPreference extends AbstractTrayPreference<CipherContentProviderStorage> {
    public static final String TAG = CipherTrayPreference.class.getCanonicalName();
    protected String cipherKey;

    public CipherTrayPreference(@NonNull Context context, @NonNull String module, int version, Type type, String cipherKey) {
        super(new CipherContentProviderStorage(context, module, type, cipherKey), version);
        this.cipherKey = cipherKey;
    }

    public CipherTrayPreference(@NonNull Context context, @NonNull String module, int version, String cipherKey) {
        this(context, module, version, Type.USER, cipherKey);
    }

    public void annexModule(String oldStorageName, Type type) {
        super.annex(new CipherContentProviderStorage(this.getContext(), oldStorageName, type, cipherKey));
    }

    public void annexModule(String oldStorageName) {
        this.annexModule(oldStorageName, Type.UNDEFINED);
    }

    protected Context getContext() {
        return ((ContentProviderStorage) this.getStorage()).getContext();
    }

    @Override
    public String getString(@NonNull String key) throws ItemNotFoundException {
        TrayItem pref = (TrayItem) this.getPref(key);
        if (pref == null) {
            throw new ItemNotFoundException("Value for Key <%s> not found", new Object[]{key});
        } else {
            String value = pref.value();
            String newValue;
            try {
                newValue = AESCodecAndroid.decrypt(value, cipherKey);
            } catch (Exception e) {
                Log.e(TAG, "getString error use original value");
                newValue = value;
            }
            return newValue;
        }
    }
}
