package com.cv.media.lib.storage.mmkv;

import android.text.TextUtils;

import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.cv.media.lib.storage.sp.CipherTrayPreference;

/**
 * Created by zhangyaoa on 2022/6/27.
 */
public class NormaPreferenceFactory implements IPreferenceFactory {
    @Override
    public IPreference create(String name, String cipherStr) {
        if(TextUtils.isEmpty(cipherStr)){
            return new NormaPreference(ContextProvider.getContext().getSharedPreferences("VALOR_MFC", 0));
        }

        return new NormaCipherPreference(new CipherTrayPreference(ContextProvider.getContext(), "user", 1, cipherStr));
    }
}
