package com.cv.media.lib.storage.preferences;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.cv.media.lib.common_utils.provider.ContextProvider;
import java.util.Set;

/**
 * Created by Joyce.wang on 2022/6/20.
 */
public class ValorPreference {
    private static final String TAG = ValorPreference.class.getSimpleName();
    private final static String APP_PREFERENCE_NAME = "VALOR_MFC";
    private SharedPreferences mSharedPreferences;

    public static ValorPreference getInstance() {
        return ValorPreference.SingletonInnerClass.INSTANCE;
    }

    static class SingletonInnerClass {
        final static ValorPreference INSTANCE = new ValorPreference();
    }
    public ValorPreference() {
        this.mSharedPreferences = ContextProvider.getContext().getSharedPreferences(APP_PREFERENCE_NAME, Context.MODE_PRIVATE);
    }

    public void putStringSet(String key, @Nullable Set<String> values) {
        mSharedPreferences.edit().putStringSet(key, values).apply();
    }

    public void putString(String key, @Nullable String value) {
        mSharedPreferences.edit().putString(key, value).apply();
    }

    public void putInt(String key, int value) {
        mSharedPreferences.edit().putInt(key, value).apply();
    }

    public void putLong(String key, long value) {
        mSharedPreferences.edit().putLong(key, value).apply();
    }

    public void putFloat(String key, float value) {
        mSharedPreferences.edit().putFloat(key, value).apply();
    }

    public void putBoolean(String key, boolean value) {
        mSharedPreferences.edit().putBoolean(key, value).apply();
    }

    public String getString(String key) {
        return getString(key, "");
    }

    public String getString(String key, @Nullable String defValue) {
        return mSharedPreferences.getString(key, defValue);
    }

    public Set<String> getStringSet(String key, @Nullable Set<String> defValues) {
        return mSharedPreferences.getStringSet(key, defValues);
    }

    public int getInt(String key, int defValue) {
        return mSharedPreferences.getInt(key, defValue);
    }

    public long getLong(String key, long defValue) {
        return mSharedPreferences.getLong(key, defValue);
    }

    public float getFloat(String key, float defValue) {
        return mSharedPreferences.getFloat(key, defValue);
    }

    public boolean getBoolean(String key, boolean defValue) {
        return mSharedPreferences.getBoolean(key, defValue);
    }

    public void remove(String key) {
        mSharedPreferences.edit().remove(key);
    }
}
