package com.cv.media.lib.ui;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.AlertDialog;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.AnimRes;
import androidx.annotation.AnimatorRes;

import com.cv.media.lib.ui.toast.ToastUtils;

import java.util.HashMap;

/**
 * Created by elegant.wang on 2016/4/15.
 *
 * @desc 动画工具类
 */

public class AnimationHelper {
    private static final String TAG = AnimationHelper.class.getSimpleName();
    public static float ZOOM_IN_SCALE = 1.1f;
    public static long ZOOM_DURATION = 200L;
    public static long FLY_DURATION = 200L;
    public static int DISPLAY_WIDTH = 0;
    public static int DISPLAY_HEIGHT = 0;
    public static double SCREEN_SIZE = 0.0;
//    public static int FLYVIEW_BORDER = 9;//todo, original 12,20190402,10

    private static ViewPropertyAnimator flyViewAnimation;

    private static HashMap<Integer, Animation> animationCache = new HashMap<>();// TODO: 2016/10/13 限制缓存的大小
    private static HashMap<Integer, AnimatorSet> animatorCache = new HashMap<>();

    public static void viewZoomIn(View view, Animator.AnimatorListener listener) {
        ViewPropertyAnimator animation = view.animate().withLayer();
        animation.scaleX(ZOOM_IN_SCALE).scaleY(ZOOM_IN_SCALE).setDuration(ZOOM_DURATION);
        if (listener != null) {
            animation.setListener(listener);
        }
        animation.start();
    }

    public static void viewZoomNormal(View view, Animator.AnimatorListener listener) {
        ViewPropertyAnimator animation = view.animate().withLayer();
        animation.scaleX(1f).scaleY(1f).setDuration(ZOOM_DURATION);
        if (listener != null) {
            animation.setListener(listener);
        }
        animation.start();
    }

    public static void viewZoomInByObjectAnimator(View view) {
        ObjectAnimator animator = new ObjectAnimator();
        animator.ofFloat(ZOOM_IN_SCALE);
        animator.setDuration(ZOOM_DURATION);
        animator.setPropertyName("scaleX");
        animator.setPropertyName("scaleY");
    }

    public static void showOnFocusAnimation(final Context context, FrameLayout frameLayout, final View foreGround, final View backGround, final ImageView whiteBorder, final boolean showWhiteBorderFlag, int viewBorder) {
        if (frameLayout == null)
            return;

        // 将当前FrameLayout置为顶层
        frameLayout.bringToFront();
        if (foreGround == null)
            return;

        Animator.AnimatorListener listener = new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                //展示出textview
                if (backGround != null && backGround instanceof TextView) {
                    backGround.setVisibility(View.VISIBLE);
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {
            }

            @Override
            public void onAnimationRepeat(Animator animation) {
            }
        };
        foreGround.clearAnimation();
        viewZoomIn(foreGround, listener);
        //飞到FrameLayout处，所以使用getParent
        //flyView((View) foreGround.getParent(), whiteBorder, android.view.animation.AnimationUtils.loadAnimation(context, R.anim.breathing), showWhiteBorderFlag, viewBorder);
    }

    public static void showOnLoseFocusAnimation(View foreground, final View background, final boolean hideBackgroud) {
        Animator.AnimatorListener listener = new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {

            }

            @Override
            public void onAnimationEnd(Animator animation) {
                if (hideBackgroud && background.getVisibility() == View.VISIBLE) {
                    background.setVisibility(View.GONE);
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {

            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        };

        viewZoomNormal(foreground, listener);
    }

    public static void zoomIn(View target) {
        if (target == null) return;
        target.clearAnimation();
        viewZoomIn(target, null);
    }

    public static void zoomNormal(View target) {
        if (target == null) return;
        target.clearAnimation();
        viewZoomNormal(target, null);
    }

    public static void showOnFocusAnimation(final Context context, View target, final View flyView, final boolean showWhiteBorderFlag, int viewBorder) {
        if (target == null) return;
        target.clearAnimation();
        viewZoomIn(target, null);
        //flyView(target, flyView, android.view.animation.AnimationUtils.loadAnimation(context, R.anim.breathing), showWhiteBorderFlag, viewBorder);
    }

    public static void showOnLoseFocusAnimation(View target) {
        viewZoomNormal(target, null);
    }

    public static void flyView(View target, final View flyView, final Animation animationAfterFly, final boolean showflyViewFlag, int viewBorder) {
        cancelFlyView(flyView);
        flyView.clearAnimation();
        int targetWidth = target.getMeasuredWidth();
        int targetHeight = target.getMeasuredHeight();
        int[] targetLocation = new int[2];
        target.getLocationOnScreen(targetLocation);
        int flyViewWidth = flyView.getWidth();
        int flyViewHeight = flyView.getHeight();
        float flyViewX = targetLocation[0] + targetWidth / 2f - flyViewWidth / 2f;
        float flyViewY = targetLocation[1] + targetHeight / 2f - flyViewHeight / 2f;

        final float translationX = targetLocation[0] - viewBorder;
        final float translationY = targetLocation[1] - viewBorder;

        Rect rect = new Rect();
        ((ViewGroup) flyView.getParent()).offsetDescendantRectToMyCoords(flyView, rect);

        final float newWidth = targetWidth + 2f * viewBorder;
        final float newHeight = targetHeight + 2f * viewBorder;

        float flyViewScaleX = newWidth / flyViewWidth;
        float flyViewScaleY = newHeight / flyViewHeight;

        flyViewAnimation = flyView.animate();
        // 这里的x与translationX y与ranslationY一致
        flyViewAnimation.x(flyViewX);
        flyViewAnimation.y(flyViewY);
        flyViewAnimation.scaleX(flyViewScaleX);
        flyViewAnimation.scaleY(flyViewScaleY);
        flyViewAnimation.setDuration(FLY_DURATION);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN) {
            flyViewAnimation.withEndAction(new Runnable() {
                @Override
                public void run() {
                    if (showflyViewFlag && flyView.getVisibility() != View.VISIBLE) {
                        flyView.setVisibility(View.VISIBLE);
                    }
                    if (animationAfterFly != null)
                        flyView.startAnimation(animationAfterFly);
                    FrameLayout.LayoutParams layoutparams = new FrameLayout.LayoutParams((int) newWidth, (int) newHeight);
                    flyView.setLayoutParams(layoutparams);
                    flyView.setTranslationX(translationX);
                    flyView.setTranslationY(translationY);
                    flyView.setScaleX(1.0f);
                    flyView.setScaleY(1.0f);
                    flyView.requestLayout();
                }
            });
        }
        flyViewAnimation.start();
    }

    public static void cancelFlyView(View v) {
        v.clearAnimation();
        if (flyViewAnimation != null) {
            flyViewAnimation.cancel();
        }
    }

    /**
     * 下面几个方法为调试使用
     */
    public static void showMyPositonToast(Context ctx, View v) {
        ToastUtils.showToast(ctx, getLocationString(v));
    }

    public static void showMyPositonWindow(Context ctx, View v) {
        AlertDialog.Builder builder = new AlertDialog.Builder(ctx);
        builder.setMessage(getLocationString(v));
        builder.show();
    }

    public static void logMyPositon(View v, String tag) {
        Log.e(TAG, getLocationString(v) + " " + tag);
    }

    private static String getLocationString(View v) {
        int[] location = new int[2];
        v.getLocationOnScreen(location);
        StringBuilder sb = new StringBuilder();
        sb.append(v.toString()).append(" 's location info:").append("x:").append(location[0]).append(" y:").append(location[1]).append(" X:").append(v.getX()).append(" Y:").append(v.getY()).append(" width:").append(v.getWidth()).append(" height:").append(v.getHeight());
        return sb.toString();
    }

    //当前时间点动画剩余时间
    public static long getRestDuration(Animation animation) {
        return animation.getDuration() - animation.getStartOffset();
    }

    public static void applyAnimation(Context context, View v, @AnimRes int resId) {
        //todo 遇到问题，暂时不用缓存
        /*Animation animation = animationCache.get(resId);
        if (animation == null) {
            animation = AnimationUtils.loadAnimation(MyApplication.getInstance(), resId);
            animation.setFillAfter(true);
            animationCache.put(resId, animation);
        }*/
        Animation animation = AnimationUtils.loadAnimation(context, resId);
        animation.reset();
        v.startAnimation(animation);
    }

    public static void applyAnimation(Context context, View v, @AnimRes int resId, final Runnable startAction, final Runnable endAction) {
        Animation animation = AnimationUtils.loadAnimation(context, resId);
        animation.setFillAfter(true);
        animation.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {
                if (startAction != null) startAction.run();
            }

            @Override
            public void onAnimationEnd(Animation animation) {
                if (endAction != null) endAction.run();
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });
        animation.reset();
        v.startAnimation(animation);
    }

    public static void applyAnimator(Context context, View v, @AnimatorRes int resId, Runnable startAction, Runnable endAction) {
        AnimatorSet animatorSet = (AnimatorSet) AnimatorInflater.loadAnimator(context, resId);
    }

    public static boolean hasAnimation(View v) {
        return v.getAnimation() != null && v.getAnimation().hasStarted() && !v.getAnimation().hasEnded();
    }

    public static void shake(Context context, View v) {
        applyAnimation(context, v, R.anim.shake);
    }

    public static void wobble(Context context, View v) {
        applyAnimation(context, v, R.anim.wobble);
    }

    public static void rotate(Context context, View v) {
        applyAnimation(context, v, R.anim.loading_rotate);
    }
}
