package com.cv.media.lib.ui.text;

import android.content.Context;
import android.graphics.Typeface;
import android.util.AttributeSet;

import com.cv.media.lib.common_utils.async.ThreadUtils;
import com.cv.media.lib.common_utils.async.ThreadsBox;

import java.util.HashMap;

public abstract class BaseTextView extends androidx.appcompat.widget.AppCompatTextView {
    private static HashMap<Class, Typeface> typefaceMaps = new HashMap<>();

    public BaseTextView(Context context) {
        super(context);
        init();
    }

    public BaseTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public BaseTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init();
    }

    private void init() {
        loadTypeFace();
    }

    private void loadTypeFace() {
        Typeface typeface;
        synchronized (typefaceMaps){
            typeface = typefaceMaps.get(getClass());
        }
        if(typeface == null) {
            //use Thread Pool to loadTypePace as soon as possible
            //if use ThreadBox, may be have to wait a moment
            ThreadUtils.execute(() -> {
                synchronized (typefaceMaps){
                    Typeface tf = typeface();
                    if(tf != null) {
                        typefaceMaps.put(BaseTextView.this.getClass(), tf);
                        ThreadsBox.getDefaultMainHandler().post(BaseTextView.this::loadTypeFace);
                    }
                }
            });
        }else {
            setTypeface(typeface);
        }
    }

   protected abstract Typeface typeface();
}
