package com.cv.media.lib.ui.viewpager;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;

import androidx.annotation.NonNull;
import androidx.viewpager.widget.ViewPager;

/**
* 给ViewPager 存储一个方向, 以确定 焦点定位
 * 配合 HomeFrameLayout
 * @see com.cv.media.lib.ui.container.HomeFrameLayout
* 职责:
* @author Damon
*/
public class HomeViewPager extends ViewPager {
    private int direction = ViewPager.FOCUS_FORWARD;
    private boolean lockFocusOutThroughLeft = true;
    private boolean lockFocusOutThroughRight = true;

    public HomeViewPager(Context context) {
        super(context);
    }

    public HomeViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean executeKeyEvent(@NonNull KeyEvent event) {
        if(event.getKeyCode() == KeyEvent.KEYCODE_DPAD_LEFT) {
            direction = ViewPager.FOCUS_BACKWARD;
        } else {
            direction = ViewPager.FOCUS_FORWARD;
        }
        boolean ref = super.executeKeyEvent(event);
        return ref;
    }

    public int getDirection() {
        return direction;
    }

    @Override
    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        return super.requestFocus(direction, previouslyFocusedRect);
    }

    @Override
    public View focusSearch(View focused, int direction) {
        if((direction == FOCUS_RIGHT && lockFocusOutThroughRight) || (direction == FOCUS_LEFT && lockFocusOutThroughLeft)) {
            //最左 最右的时候 按下 左 或 右, 不进行焦点移动
            return null;
        }
        return super.focusSearch(focused, direction);
    }

    public void setLockFocusOutThroughLeft(boolean lockFocusOutThroughLeft) {
        this.lockFocusOutThroughLeft = lockFocusOutThroughLeft;
    }

    public void setLockFocusOutThroughRight(boolean lockFocusOutThroughRight) {
        this.lockFocusOutThroughRight = lockFocusOutThroughRight;
    }
}
