package com.cv.media.lib.ui.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.View.OnClickListener;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.widget.AppCompatEditText;

import com.cv.media.lib.ui.R;

/**
 * Created by zhangyaoa on 2018/8/22.
 */

public class NoticeDialog {
    private Context context;
    private Dialog dialog;
    private CheckBox checkbox;
    private LinearLayout layoutNoremaind ,btn_layout;
    private TextView txt_title;
    private View txt_line;
    private TextView txt_remaind;
    private TextView txt_msg;
    private TextView tv_more_info;

    private TextView btn_underline;
    private Button btn_neg;
    private Button btn_pos;
    private boolean showTitle = false;
    private boolean showMsg = false;
    private boolean showMoreInfo = false;
    private boolean showPosBtn = false;
    private boolean showNegBtn = false;

    private boolean showUnderLineBtn = false;

    private NoticeDialog(Context context) {
        this.context = context;
    }

    public static NoticeDialog builder(Context context) {
        return new NoticeDialog(context).create();
    }

    public static NoticeDialog builder(Context context, int widthId) {
        return new NoticeDialog(context).create(widthId);
    }

    private NoticeDialog create(int widthId) {
        View view = LayoutInflater.from(context).inflate(
                R.layout.v_lib_alert_dialog, null);

        layoutNoremaind = (LinearLayout) view.findViewById(R.id.layout_no_remaind);
        btn_layout = (LinearLayout) view.findViewById(R.id.btn_layout);
        checkbox = (CheckBox) view.findViewById(R.id.checkbox);
        txt_title = (TextView) view.findViewById(R.id.txt_title);
        txt_line = view.findViewById(R.id.txt_line);
        txt_remaind = (TextView) view.findViewById(R.id.tv_remaind);
        txt_msg = (TextView) view.findViewById(R.id.txt_msg);
        tv_more_info = (TextView) view.findViewById(R.id.tv_more_info);
        btn_pos = (Button) view.findViewById(R.id.btn_positive);
        btn_neg = (Button) view.findViewById(R.id.btn_negative);

        btn_underline = view.findViewById(R.id.btn_underline);
        btn_underline.setPaintFlags(btn_underline.getPaintFlags()| Paint.UNDERLINE_TEXT_FLAG);

        dialog = new Dialog(context, R.style.AlertDialogDark);
        dialog.setContentView(view);

//        lLayout_bg.setLayoutParams(new FrameLayout.LayoutParams((int) (DensityUtil.screenWidthPx * 0.8), LayoutParams.WRAP_CONTENT));
        dialog.getWindow().setLayout((int) context.getResources().getDimension(widthId), ViewGroup.LayoutParams.WRAP_CONTENT);
//        FontUtils.setFontTypeface(context, "Roboto-Medium.ttf", et_input);
        return this;
    }

    private NoticeDialog create() {
        return create(R.dimen.c_ui_dialog_width);
    }

    public NoticeDialog setButtonLayoutVertical(){
        btn_layout.setOrientation(LinearLayout.VERTICAL);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        layoutParams.weight = 0;
        layoutParams.height = context.getResources().getDimensionPixelSize(R.dimen.lib_button_dialog_height);
        btn_pos.setLayoutParams(layoutParams);

        layoutParams.topMargin = context.getResources().getDimensionPixelSize(R.dimen.lib_button_dialog_margin);
        btn_neg.setLayoutParams(layoutParams);
        return this;
    }

    public NoticeDialog setTitle(String title) {
        showTitle = true;
        txt_title.setText(title);
        return this;
    }

    public NoticeDialog setTitle(int id) {
        showTitle = true;
        txt_title.setText(getStrings(id));
        return this;
    }

    public NoticeDialog setMsg(String msg) {
        showMsg = true;
        txt_msg.setText(msg);
        return this;
    }

    public NoticeDialog setMsg(int id) {
        showMsg = true;
        txt_msg.setText(getStrings(id));
        return this;
    }

    public NoticeDialog setMoreInfo(int id) {
        showMoreInfo = true;
        tv_more_info.setText(getStrings(id));
        return this;
    }

    public NoticeDialog setMsg(String msg, boolean lotNum) {
        showMsg = true;
        if ("".equals(msg)) {
            txt_msg.setText("");
        } else {
            txt_msg.setText(msg);
        }

        if (lotNum) {//表示文字比较多的情况
            txt_msg.setGravity(Gravity.LEFT);
            txt_msg.setLineSpacing(0, 1.3f);
        }

        return this;
    }

    public NoticeDialog setNoremaindEnable(CompoundButton.OnCheckedChangeListener listener) {
        layoutNoremaind.setVisibility(View.VISIBLE);
        checkbox.setOnCheckedChangeListener(listener);
        return this;
    }

    public NoticeDialog setCancelable(boolean cancel) {
        dialog.setCancelable(cancel);
        return this;
    }

    public NoticeDialog setPositiveButton(String text, final OnClickListener listener) {
        showPosBtn = true;
        btn_pos.setText(text);
        btn_pos.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
                dialog.dismiss();
            }
        });
        return this;
    }

    public NoticeDialog setPositiveButton(int id, final OnClickListener listener) {
        return setPositiveButton(id, false, listener);
    }

    public NoticeDialog setPositiveButton(int id, boolean focus, final OnClickListener listener) {
        if (id == -1) {
            return this;
        }

        showPosBtn = true;
        btn_pos.setText(getStrings(id));
        btn_pos.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
                dialog.dismiss();
            }
        });

        if (focus) {
            btn_pos.post(new Runnable() {
                @Override
                public void run() {
                    btn_pos.requestFocus();
                }
            });
        }
        return this;
    }


    public NoticeDialog setNegativeButton(String text, final OnClickListener listener) {
        showNegBtn = true;
        btn_neg.setText(text);
        btn_neg.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
                dialog.dismiss();
            }
        });
        return this;
    }

    public NoticeDialog setNegativeButton(int id, final OnClickListener listener) {
        if (id == -1) {
            return this;
        }

        showNegBtn = true;
        btn_neg.setText(getStrings(id));
        btn_neg.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
                dialog.dismiss();
            }
        });
        return this;
    }

    public NoticeDialog setUnderLineButton(int id, final OnClickListener listener) {
        if (id == -1) {
            return this;
        }

        showUnderLineBtn = true;
        btn_underline.setText(getStrings(id));
        btn_underline.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
                dialog.dismiss();
            }
        });
        return this;
    }

    public NoticeDialog setUnderLineButton(String text, final OnClickListener listener) {
        if (TextUtils.isEmpty(text)) {
            return this;
        }

        showUnderLineBtn = true;
        btn_underline.setText(text);
        btn_underline.setOnClickListener(new OnClickListener() {
            @Override
            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
                dialog.dismiss();
            }
        });
        return this;
    }

    private void setLayout() {
        if (showTitle) {
            txt_title.setVisibility(View.VISIBLE);
            txt_line.setVisibility(View.VISIBLE);
        }

        if (showMsg) {
            txt_msg.setVisibility(View.VISIBLE);
        }


        if (showMoreInfo) {
            tv_more_info.setVisibility(View.VISIBLE);
        }

        if (showPosBtn && showNegBtn) {
            btn_pos.setVisibility(View.VISIBLE);
            btn_neg.setVisibility(View.VISIBLE);
        } else if (showPosBtn && !showNegBtn) {
            btn_pos.setVisibility(View.VISIBLE);
        } else if (!showPosBtn && showNegBtn) {
            btn_neg.setVisibility(View.VISIBLE);
        }

        if(showUnderLineBtn){
            btn_underline.setVisibility(View.VISIBLE);
        }
    }

    public void show() {
        setLayout();
        if (dialog == null || dialog.isShowing()) {
            return;
        }
        if (context instanceof Activity && ((Activity) context).isFinishing()) {
            return;
        }
        dialog.show();
    }

    public boolean isShowing() {
        return dialog != null && dialog.isShowing();
    }


    public void hide() {
        if (dialog != null && dialog.isShowing()) {
            dialog.dismiss();
        }
    }

    private String getStrings(int id) {
        return context.getResources().getString(id);
    }
}