package com.cv.media.lib.ui.text;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputMethodManager;
import android.widget.BaseAdapter;
import android.widget.Filter;
import android.widget.Filterable;
import android.widget.ListView;
import android.widget.TextView;

import com.cv.media.lib.common_utils.utils.PatternUtils;
import com.cv.media.lib.ui.R;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;


public class ACView extends androidx.appcompat.widget.AppCompatAutoCompleteTextView implements TextView.OnEditorActionListener {
    InputMethodManager mInputManager;
    boolean ignoreSelectAllCauseLongClick = false;

    public ACView(Context context, AttributeSet attrs) {
        super(context, attrs);
        setOnEditorActionListener(this);
        mInputManager = (InputMethodManager) getContext().getSystemService(Context.INPUT_METHOD_SERVICE);
        setEmailDomains(new String[]{"gmail.com", "hotmail.com", "outlook.com", "yahoo.com.br", "yahoo.com"});
    }

    private void init() {
        setThreshold(1);
        setAdapter(new ACAdapter());
    }

    @Override
    public boolean performLongClick() {
        if (ignoreSelectAllCauseLongClick) {
            ignoreSelectAllCauseLongClick = false;
            return true;
        }
        return super.performLongClick();
    }

    @Override
    public boolean onKeyPreIme(int keyCode, KeyEvent event) {
        return false;
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if ((keyCode == KeyEvent.KEYCODE_DPAD_CENTER || keyCode == KeyEvent.KEYCODE_ENTER) && getListSelection() == ListView.INVALID_POSITION) {
            //center--->弹键盘
            if (requestFocus()) {
                ignoreSelectAllCauseLongClick = true;
                mInputManager.showSoftInput(this, 0);
                return true;
            }
        } else if (isPopupShowing() && keyCode == KeyEvent.KEYCODE_BACK) {
            //back-->隐藏dropdown
            dismissDropDown();
            return true;
        }

        /*#323265 java.lang.IllegalStateException
        focus search returned a view that wasn't able to take focus!
        android.widget.TextView.onKeyUp(TextView.java:6413)*/
        try {
            return super.onKeyUp(keyCode, event);
        } catch (Exception e) {
            return true;
        }
    }

    List<String> mEmailDomains = new ArrayList<>();
    final ArrayList<String> mDatas = new ArrayList<>();

    public void setEmailDomains(String[] domains) {
        if (domains != null && domains.length > 0) {
            mEmailDomains = Arrays.asList(domains);
            init();
        }
    }

    @Override
    public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
        if (actionId == EditorInfo.IME_ACTION_NEXT) {
            View nextFocus = focusSearch(View.FOCUS_DOWN);
            if (nextFocus != null) {
                nextFocus.requestFocus();
            }
            return true;
        }
        return false;
    }


    private class ACAdapter extends BaseAdapter implements Filterable {
        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            TextView v = (TextView) (convertView == null ? LayoutInflater.from(parent.getContext()).inflate(R.layout.v_item_email, parent, false) : convertView);
            v.setText((CharSequence) getItem(position));
            return v;
        }

        @Override
        public int getCount() {
            return mDatas.size();
        }

        @Override
        public Object getItem(int position) {
            return mDatas.get(position);
        }

        @Override
        public long getItemId(int position) {
            return position;
        }

        String regex = "@";

        @Override
        public Filter getFilter() {
            return new Filter() {
                @Override
                protected FilterResults performFiltering(CharSequence constraint) {
                    String str = constraint.toString();
                    Matcher m = PatternUtils.patt(regex).matcher(constraint);
                    int count = 0;
                    while (m.find()) {
                        count++;
                    }
                    if (count == 1) {
                        ArrayList tmp = new ArrayList();
                        FilterResults results = new FilterResults();
                        int index = str.indexOf(regex);
                        if (str.length() - index == 1) {
                            //最后一个是@
                            for (String domain : mEmailDomains) {
                                tmp.add(constraint + domain);
                            }
                        } else {
                            //最后一个是@xx
                            String filtStr = str.substring(index).replace("@", "");
                            for (String domain : mEmailDomains) {
                                if (domain.startsWith(filtStr) && !filtStr.equals(domain)) {
                                    tmp.add(constraint + domain.replaceFirst(filtStr, ""));
                                }
                            }
                        }

                        results.values = tmp;
                        results.count = tmp.size();
                        return results;
                    }
                    return null;
                }

                @Override
                protected void publishResults(CharSequence constraint, FilterResults results) {
                    mDatas.clear();
                    mDatas.addAll((Collection<? extends String>) ((results == null || results.values == null) ? new ArrayList<>() : results.values));
                    notifyDataSetChanged();
                }
            };
        }
    }
}
