package com.cv.media.lib.ui.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;

import androidx.annotation.Nullable;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import com.cv.media.lib.ui.R;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MarqueeViewEX extends FrameLayout implements View.OnClickListener {
    public MarqueeView mMarquee;
    ImageView mImage;

    CallBack cb;

    private final List<MessageInfo> mMessages = new ArrayList<>();
    private final List<MarqueeView.Notice> notices = new ArrayList<>();

    Handler mHandler = new Handler(Looper.getMainLooper());

    public MarqueeViewEX(Context context) {
        super(context);
        init();
    }

    public MarqueeViewEX(Context context, AttributeSet attrs) {
        super(context, attrs);
        init();
    }

    public void setNotices(List<MarqueeView.Notice> notices) {
        this.notices.clear();
        this.notices.addAll(notices);
        handleNotices(notices);
    }
    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    private void init() {
        setFocusable(false);
        setFocusableInTouchMode(false);
        setDescendantFocusability(FOCUS_BEFORE_DESCENDANTS);
        setOnClickListener(this);
        LayoutInflater.from(getContext()).inflate(R.layout.v_marquee_ex, this);
        mMarquee = findViewById(R.id.mqv_display);
        mMarquee.setFocusable(false);
        mImage = findViewById(R.id.iv_Display);
        mImage.setFocusable(false);
    }

    private void handleNotices(List<MarqueeView.Notice> noticeInfos) {
        mMessages.clear();
        if (noticeInfos != null && noticeInfos.size() > 0) {
            MarqueeView.Notice noticeInfo = noticeInfos.get(0);
            if (noticeInfo.image != null && !noticeInfo.image.isEmpty()) {
                mMessages.add(new ImageMessage(noticeInfo.image, noticeInfo.url));
            } else {
                mMessages.add(new TextMessage(noticeInfo.message, null, noticeInfo));
            }
        } else {
            mMessages.add(new NoMessage(null, null));
        }

        mMessages.get(0).run();
    }

    @Override
    public void onClick(View v) {
        if (!mMessages.isEmpty()) mMessages.get(0).onClick();
    }

    public void setCb(CallBack cb) {
        this.cb = cb;
    }

    public interface CallBack {
        void onLink(String url);

        void onImgLink(String url);

        void onText(CharSequence str);
    }

    abstract class MessageInfo implements Runnable {
        String display;
        String content;

        public MessageInfo(String display, String content) {
            this.display = display;
            this.content = content;
        }

        abstract public void onClick();

        final String imageLinkRegex = "[^\\s]*(\\.png|\\.jpg|\\.jpeg)$";

        boolean isImageLinkContent() {
            return content != null && !content.isEmpty() && content.toLowerCase().matches(imageLinkRegex);
        }

        boolean isWebLinkContent() {
            return content != null && !content.isEmpty();
        }

        boolean isTextContent() {
            return content == null || content.isEmpty();
        }
    }

    class ImageMessage extends MessageInfo {
        public ImageMessage(String display, String content) {
            super(display, content);
        }

        @Override
        public void run() {
            mMarquee.setVisibility(GONE);
            Glide.with(getContext()).load(display).fitCenter().addListener(new RequestListener<Drawable>() {
                @Override
                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                    setFocusable(false);
                    setFocusableInTouchMode(false);
                    return false;
                }

                @Override
                public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                    mImage.setVisibility(VISIBLE);
                    setFocusable(true);
                    setFocusableInTouchMode(true);
                    return false;
                }
            }).into(mImage);
        }

        @Override
        public void onClick() {
            if (cb != null) {
                if (isImageLinkContent()) {
                    cb.onImgLink(content);
                    return;
                }

                if (isWebLinkContent()) {
                    cb.onLink(content);
                    return;
                }
            }
        }
    }

    class TextMessage extends MessageInfo {
        MarqueeView.Notice mNoticeInfo;

        public TextMessage(String display, String content, MarqueeView.Notice noticeInfo) {
            super(display, content);
            mNoticeInfo = noticeInfo;
        }

        @Override
        public void run() {
            mImage.setVisibility(GONE);
            mMarquee.setVisibility(VISIBLE);
            Glide.with(getContext()).clear(mImage);
            if (mNoticeInfo != null) mMarquee.extractNoticeInfosOrignal(Arrays.asList(mNoticeInfo));
            setFocusable(true);
            setFocusableInTouchMode(true);
        }

        @Override
        public void onClick() {
            if (cb != null) {
                if (isTextContent()) {
                    cb.onText(display);
                    return;
                }
            }
        }
    }

    class NoMessage extends MessageInfo {
        public NoMessage(String display, String content) {
            super(display, content);
        }

        @Override
        public void run() {
            Glide.with(getContext()).clear(mImage);
            mImage.setVisibility(INVISIBLE);
            mMarquee.setVisibility(INVISIBLE);
            if (isFocused()) {
                View v = focusSearch(FOCUS_RIGHT);
                if (v != null) v.requestFocus();
            }
            setFocusable(false);
        }

        @Override
        public void onClick() {
        }
    }
}
