package com.cv.media.lib.ui.focus;

import android.content.Context;
import android.util.AttributeSet;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;

import java.util.ArrayList;

/**
* 锁定 焦点移动
* 职责:
* @author Damon
*/
public class FocusMoveLockLayout extends FrameLayout {
    private int[] mDirections = {FOCUS_RIGHT, FOCUS_LEFT, FOCUS_UP, FOCUS_DOWN};
    public FocusMoveLockLayout(@NonNull Context context) {
        super(context);
    }

    public FocusMoveLockLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public void setSupportFocusMoveDirection(@ViewCompat.FocusDirection int[] directions){
        mDirections = directions;
    }

    @Override
    public View focusSearch(View focused, int direction) {
        View view = FocusFinder.getInstance().findNextFocus(this, focused, direction);
        if (view == null) {
            if (mDirections != null) {
                for (int i = 0; i < mDirections.length; i++) {
                    if (mDirections[i] == direction) {
                        return super.focusSearch(focused, direction);
                    }
                }
            }
            return null;
        }
        return view;
    }
}
