package com.cv.media.lib.ui.container;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import android.widget.FrameLayout;

import androidx.viewpager.widget.ViewPager;


import com.cv.media.lib.ui.viewpager.HomeViewPager;

import java.util.ArrayList;

/**
 * 配合HomeViewPager使用,
 * HomeViewPager里 的 每一个Fragment 的 根视图 应为HomeFrameLayout
 */
public class HomeFrameLayout extends FrameLayout {
    public HomeFrameLayout(Context context) {
        super(context);
    }

    public HomeFrameLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }


    @Override
    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        ViewParent vp = getParent();
        while(vp != null && !(vp instanceof HomeViewPager)) {
            vp = vp.getParent();
        }
        if(vp != null) {
            int d = ((HomeViewPager)vp).getDirection();
            ArrayList<View> views = getFocusables(FOCUS_LEFT);
            if(d == ViewPager.FOCUS_BACKWARD) {
                return views.get(views.size() - 1).requestFocus();
            }else if(d == ViewPager.FOCUS_FORWARD) {
                return views.get(0).requestFocus();
            }
        }
        return super.requestFocus(direction, previouslyFocusedRect);
    }

}
