package com.cv.media.lib.ui.focus;

import android.content.Context;
import android.graphics.Rect;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by elegant.wang on 2017/9/13.
 */

public class FullPersistentFocusWrapper extends PersistentFocusWrapper {
    private static final String TAG = "FPFW";
    private List<Integer> mSelectedPositions = new ArrayList<>();

    public FullPersistentFocusWrapper(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public FullPersistentFocusWrapper(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    public void requestChildFocus(View child, View focused) {
        super.requestChildFocus(child, focused);
        mSelectedPositions.clear();
        View view = focused;
        while (view != null && view.getParent() != child) {
            int subSelected = ((ViewGroup) view.getParent()).indexOfChild(view);
            mSelectedPositions.add(0, subSelected);
            view = (View) view.getParent();
        }
        mSelectedPosition = view == null ? -1 : ((ViewGroup) child).indexOfChild(view);
        mSelectedPositions.add(0, mSelectedPosition);
        if (DEBUG)
            Log.v(TAG, "requestChildFocus focused " + focused + " mSelectedPosition " + mSelectedPosition);
    }

    @Override
    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (DEBUG) Log.v(TAG, "requestFocus mSelectedPosition " + mSelectedPosition);
        ViewGroup focusViewGroup = (ViewGroup) getChildAt(0);
        View focusView = null;
        if (focusViewGroup != null && mSelectedPositions.size() > 0) {
            for (int i = 0; i < mSelectedPositions.size() - 1; i++) {
                View focusChild = focusViewGroup.getChildAt(mSelectedPositions.get(i));
                if (focusChild != null && focusChild instanceof ViewGroup) {
                    focusViewGroup = (ViewGroup) focusChild;
                } else {
                    focusViewGroup = null;
                    break;
                }
            }
            if (focusViewGroup != null) {
                focusView = focusViewGroup.getChildAt(mSelectedPositions.get(mSelectedPositions.size() - 1));
                if (focusView != null && focusView.requestFocus(direction, previouslyFocusedRect)) {
                    return true;
                }
            }
        }
        return super.requestFocus(direction, previouslyFocusedRect);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return super.onSaveInstanceState();
    }
}
