package com.cv.media.lib.ui.button;

import android.content.Context;
import android.content.res.Resources;
import android.util.AttributeSet;
import android.view.Gravity;

import androidx.appcompat.widget.AppCompatButton;

import com.cv.media.lib.ui.R;

/**
 * Created by zhangyaoa on 2023/11/13.
 */
public class PrimaryButton extends AppCompatButton {
    public PrimaryButton(Context context) {
        this(context, null);
    }

    public PrimaryButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PrimaryButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void init(Context context){
        Resources resources = context.getResources();

        setBackground(resources.getDrawable(backgroundRes()));
        setTextColor(resources.getColor(textColorRes()));
        setGravity(Gravity.CENTER);
    }

    protected int textColorRes() {
        return R.drawable.lib_selector_primary_button_text_color;
    }

    protected int backgroundRes() {
        return R.drawable.lib_selector_primary_button;
    }

}
