package com.cv.media.lib.ui.progressview;

import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;

import com.cv.media.lib.ui.R;


/**
 * @author joychang
 */
public class LoadingDialog extends Dialog {
    private TextView tv_loading;
    private ProgressBar pb_loading;

    public LoadingDialog(Context paramContext) {
        this(paramContext, R.style.Exitdialog);
    }

    public LoadingDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
        View loadingView = LayoutInflater.from(context).inflate(
                R.layout.loading_dialog, null);
        tv_loading = (TextView) loadingView
                .findViewById(R.id.loading_tv);
        pb_loading = loadingView.findViewById(R.id.loading_pb);
//		ImageView iv_loading = (ImageView) loadingView
//				.findViewById(R.id.live_loading_img);
//		Animation localAnimation = AnimationUtils.loadAnimation(paramContext,
//				R.anim.loading_rotate);
//		iv_loading.startAnimation(localAnimation);
        setCancelable(true);
        setContentView(loadingView);
    }

    public void setPbDrawableId(int id) {
        try {
            if (id > 0) {
                this.pb_loading.setIndeterminateDrawable(ContextCompat.getDrawable(getContext(), id));
            }
        } catch (Exception e) {

        }
    }

    public void setLoadingMsg(String paramString) {
        if (TextUtils.isEmpty(paramString)) {
            this.tv_loading.setVisibility(View.GONE);
        } else {
            this.tv_loading.setVisibility(View.VISIBLE);
        }
        this.tv_loading.setText(paramString);
    }

    public void setLoadingMsgSize(float msgSize) {
        if (msgSize <= 0) {
            return;
        }
        this.tv_loading.setTextSize(msgSize);
    }
}