package com.cv.media.lib.ui.emoji;

import com.cv.media.lib.common_utils.async.ThreadUtils;
import com.cv.media.lib.common_utils.provider.ContextProvider;
import com.cv.media.lib.common_utils.utils.JsonUtil;
import com.cv.media.lib.ui.R;
import com.google.gson.reflect.TypeToken;

import java.util.HashMap;

/**
 * Created by zhangyaoa on 2023/3/8.
 */
public class DefaultEmojiProvider implements IEmojiProvider {
    private static final HashMap<String, String> sEmojisMap = new HashMap(50);

    static {
        sEmojisMap.put("[xx01]", "emoji_bie");
        sEmojisMap.put("[xx02]", "emoji_dianshi");
        sEmojisMap.put("[xx03]", "emoji_famale");
        sEmojisMap.put("[xx04]", "emoji_weixiao");
        sEmojisMap.put("[xx05]", "emoji_woman");
    }

    @Override
    public int getEmojiResource(CharSequence key) {
        try {
            return ContextProvider.getContext().getResources().getIdentifier(sEmojisMap.get(key.toString()),"drawable",ContextProvider.getContext().getPackageName());
        }catch (Exception e){
            return -1;
        }
    }

    @Override
    public void parsEmojiSheet(String jsonPath) {
        ThreadUtils.execute(() -> {
            try {
                sEmojisMap.putAll(JsonUtil.parseJsonToMap(JsonUtil.getJsonFromAssets(jsonPath, ContextProvider.getContext())
                        , new TypeToken<HashMap<String, String>>(){}.getType()));
            } catch (Exception e) {

            }
        });
    }
}
