package com.cv.media.lib.ui.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.Paint;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.cv.media.lib.ui.R;

/**
 * Created by zhangyaoa on 2023/11/22.
 */
public class FloatDialog {

    private Context context;

    private Dialog dialog;

    private TextView txt_msg;

    private Button btn_pos;

    private FloatDialog(Context context) {
        this.context = context;
    }

    public static FloatDialog builder(Context context) {
        return new FloatDialog(context).create();
    }

    public static FloatDialog builder(Context context, int widthId) {
        return new FloatDialog(context).create(widthId);
    }

    private FloatDialog create() {
        return create(R.dimen.c_ui_dialog_width);
    }

    private FloatDialog create(int widthId) {
        View view = LayoutInflater.from(context).inflate(
                R.layout.v_lib_float_dialog, null);

        txt_msg = (TextView) view.findViewById(R.id.txt_msg);
        btn_pos = (Button) view.findViewById(R.id.btn_positive);

        view.findViewById(R.id.icon_close).setOnClickListener(v->{
            dialog.dismiss();
        });


        dialog = new Dialog(context, R.style.FloatDialogLight);
        dialog.setContentView(view);

//        lLayout_bg.setLayoutParams(new FrameLayout.LayoutParams((int) (DensityUtil.screenWidthPx * 0.8), LayoutParams.WRAP_CONTENT));
        dialog.getWindow().setLayout((int) context.getResources().getDimension(widthId), ViewGroup.LayoutParams.WRAP_CONTENT);
//        FontUtils.setFontTypeface(context, "Roboto-Medium.ttf", et_input);

        return this;
    }

    public FloatDialog setMsg(String msg) {
        txt_msg.setText(msg);
        return this;
    }

    public FloatDialog setMsg(int id) {
        txt_msg.setText(getStrings(id));
        return this;
    }

    public FloatDialog setPositiveButton(int id, final View.OnClickListener listener) {
        return setPositiveButton(id, false, listener);
    }

    public FloatDialog setPositiveButton(int id, boolean focus, final View.OnClickListener listener) {
        if (id == -1) {
            return this;
        }

        btn_pos.setText(getStrings(id));
        btn_pos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
                dialog.dismiss();
            }
        });

        if (focus) {
            btn_pos.post(new Runnable() {
                @Override
                public void run() {
                    btn_pos.requestFocus();
                }
            });
        }
        return this;
    }

    public FloatDialog setPositiveButton(String text, final View.OnClickListener listener) {
        btn_pos.setText(text);
        btn_pos.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (listener != null) {
                    listener.onClick(v);
                }
                dialog.dismiss();
            }
        });
        return this;
    }

    public void show() {
        if (dialog == null || dialog.isShowing()) {
            return;
        }
        if (context instanceof Activity && ((Activity) context).isFinishing()) {
            return;
        }
        dialog.show();
    }

    public FloatDialog setCancelable(boolean cancel) {
        dialog.setCancelable(cancel);
        return this;
    }

    private String getStrings(int id) {
        return context.getResources().getString(id);
    }
}
