package com.cv.media.lib.ui.view;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.text.Html;
import android.text.SpannableString;
import android.text.Spanned;
import android.text.StaticLayout;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;

import com.cv.media.lib.common_utils.utils.StringUtils;
import com.cv.media.lib.common_utils.utils.UiUtils;
import com.cv.media.lib.ui.AnimationHelper;
import com.cv.media.lib.ui.R;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;


/**
 * Provides a simple marquee effect for a single {@link TextView}.
 *
 * @author Sebastian Roth <sebastian.roth@gmail.com>
 */
public class MarqueeView extends LinearLayout {
    private TextView mTextField;
    private ImageView mImageView;

    private ScrollView mScrollView;

    private static final int TEXTVIEW_VIRTUAL_WIDTH = 2000;

    private ObjectAnimator mMoveTextOut = null;

    private Paint mPaint;

    private boolean mMarqueeNeeded = true;

    private static final String TAG = MarqueeView.class.getSimpleName();

    private float mTextDifference;

    /**
     * Control the speed. The lower this value, the faster it will scroll.
     */
    private static final int DEFAULT_SPEED = 60;

    /**
     * Control the pause between the animations. Also, after starting this activity.
     */
    private static final int DEFAULT_ANIMATION_PAUSE = 2000;

    private int mSpeed = DEFAULT_SPEED;

    private int mAnimationPause = DEFAULT_ANIMATION_PAUSE;

    private int mSeparatorType = SEPARATOR_TYPE_SEQ;
    //分隔符
    private String mSeparatorText = "<img src='" + R.drawable.marquee_speaker + "'/>" + "    ";

    private boolean mAutoStart = false;

    private Interpolator mInterpolator = new LinearInterpolator();

    private boolean mCancelled = false;
    private Runnable mAnimationStartRunnable;

    private boolean mStarted;

    private float mTextWidth;

    private boolean mMessageChanged = false;
    private String mMessage; //当前显示内容
    private List<String> mMessageId = new ArrayList<String>(); //当前显示的消息id列表
    private String mMessageIdStr; //中间变量

    private static Bundle saveState = new Bundle();



    private static class SaveStateKey {
        //保存信息的key 是否有保存信息，保存的消息，动画剩余时间，位置
        private static String STATE_FLAG = "exists_save_state";
        private static String MESSAGE = "save_message";
        private static String REST_DIRATION = "rest_duration";
        private static String TRASLATION_X = "tarnslation_x";
        private static String MESSSAGE_ID = "message_id";
    }

    private static int SEPARATOR_TYPE_SEQ = 0; //序号
    private static int SEPARATOR_TYPE_TEXT = 1; //指定字符


    /**
     * Sets the animation speed.
     * The lower the value, the faster the animation will be displayed.
     *
     * @param speed Milliseconds per PX.
     */
    public void setSpeed(int speed) {
        this.mSpeed = speed;
    }

    /**
     * Sets the pause between animations
     *
     * @param pause In milliseconds.
     */
    public void setPauseBetweenAnimations(int pause) {
        this.mAnimationPause = pause;
    }

    /**
     * Sets a custom interpolator for the animation.
     *
     * @param interpolator Animation interpolator.
     */
    public void setInterpolator(Interpolator interpolator) {
        this.mInterpolator = interpolator;
    }


    @SuppressWarnings({"UnusedDeclaration"})
    public MarqueeView(Context context) {
        super(context);
        init(context);
    }

    @SuppressWarnings({"UnusedDeclaration"})
    public MarqueeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        init(context);
        extractAttributes(attrs);
    }

    @TargetApi(Build.VERSION_CODES.HONEYCOMB)
    public MarqueeView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init(context);
        extractAttributes(attrs);
    }


    private void extractAttributes(AttributeSet attrs) {
        if (getContext() == null) {
            return;
        }

        TypedArray a = getContext().obtainStyledAttributes(attrs, R.styleable.MarqueeView);

        if (a == null) {
            return;
        }

        mSpeed = a.getInteger(R.styleable.MarqueeView_speed, DEFAULT_SPEED);
        mAnimationPause = a.getInteger(R.styleable.MarqueeView_mqvPause, DEFAULT_ANIMATION_PAUSE);
        mAutoStart = a.getBoolean(R.styleable.MarqueeView_autoStart, false);
        mSeparatorType = a.getInt(R.styleable.MarqueeView_separatorType, 0);
//        mSeparatorText = a.getString(R.styleable.MarqueeView_separatorText);

        a.recycle();
    }

    private void init(Context context) {
        // init helper
        mPaint = new Paint();
        mPaint.setAntiAlias(true);
        mPaint.setStrokeWidth(1);
        mPaint.setStrokeCap(Paint.Cap.ROUND);

        mInterpolator = new LinearInterpolator();
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        initView(getContext());
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);

        if (getChildCount() == 0) {
            throw new RuntimeException("MarqueeView must have child element.");
        }

        if (changed) {
            View v = getChildAt(0);
            // Fixes #1: Exception when using android:layout_width="fill_parent". There seems to be an additional ScrollView parent.
            if (v instanceof ScrollView && ((ScrollView) v).getChildCount() == 1) {
                v = ((ScrollView) v).getChildAt(0);
            }

            if (!(v instanceof TextView)) {
                throw new RuntimeException("The child view of this MarqueeView must be a TextView instance.");
            }


            prepareAnimation();

            if (mAutoStart) {
//                startMarquee();
                //resumeMarquee(); // TODO: 2016/10/8 暂时屏蔽 by elegant@2016年10月8日19:47:41
            }
        }
    }

    /**
     * Starts the configured marquee effect.
     */
    public void startMarquee() {
        if (mMarqueeNeeded) {
            startTextFieldAnimation();
        }

        mCancelled = false;
        mStarted = true;
    }

    private void startTextFieldAnimation() {
        mAnimationStartRunnable = new Runnable() {
            public void run() {
//                mTextField.startAnimation(mMoveTextOut);
                mTextField.setVisibility(VISIBLE);
                mMoveTextOut.start();
            }
        };
        postDelayed(mAnimationStartRunnable, mAnimationPause);
    }

    /**
     * Disables the animations.
     */
    public void reset() {
        mCancelled = true;

        if (mAnimationStartRunnable != null) {
            removeCallbacks(mAnimationStartRunnable);
        }

        mTextField.clearAnimation();
        mTextField.setVisibility(INVISIBLE);
        mStarted = false;

//        mMoveTextOut.reset();
        invalidate();
    }

    private void prepareAnimation() {
        // Measure
        mPaint.setTextSize(mTextField.getTextSize());
        mPaint.setTypeface(mTextField.getTypeface());
        mMessage = mTextField.getText().toString();
        // TODO: 2016/10/8 暂时屏蔽通知消息 by elegant @2016年10月8日19:44:46
        prepareTextOutAnimation(false, 0);
    }

    private void initView(Context context) {
        View view = getChildAt(0);
        if (!(view instanceof TextView))
            return;

        // Scroll View
        LayoutParams sv1lp = new LayoutParams(LayoutParams.MATCH_PARENT, LayoutParams.WRAP_CONTENT);
        sv1lp.gravity = Gravity.CENTER_VERTICAL;

        mScrollView = new ScrollView(context);
        mScrollView.setFocusable(false);

        // Scroll View 1 - Text Field
        mTextField = (TextView) getChildAt(0);
        removeView(mTextField);
        ScrollView.LayoutParams lp = new ScrollView.LayoutParams(TEXTVIEW_VIRTUAL_WIDTH, LayoutParams.WRAP_CONTENT);
        mScrollView.addView(mTextField, lp);
        mTextField.setVisibility(INVISIBLE);
        mTextField.setGravity(Gravity.CENTER);
        addView(mScrollView, sv1lp);

        mImageView = new ImageView(getContext());
        addView(mImageView, new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT));
    }

    private void expandTextView() {
        if(mTextField.getLayoutParams().width != mTextWidth) {
            ViewGroup.LayoutParams lp = mTextField.getLayoutParams();
            lp.width = (int) mTextWidth;
            mTextField.setLayoutParams(lp);
        }
    }

//    public void setMessage(List<NoticeInfo> noticeInfos) {
//        LogUtils.i(TAG, "<<<<<setMessage>>>>>");
//        extractNoticeInfos(noticeInfos);
//        if (mStarted) {
//            mMessageChanged = true;
//        } else {
//            if (StringUtils.trimToNull(mMessage) != null) {
//                mTextField.setText(extraMsgToSpan());
//                mMarqueeNeeded = true;
//                startMarquee();
//            }
//        }
//    }

    //是否从指定位置开始，如果是则使用startX作为动画开始位置
    private void prepareTextOutAnimation(boolean rd, float startX) {
        //if (StringUtils.trimToNull(mMessage) != null) mMarqueeNeeded = true;
        mMarqueeNeeded = true;
        //measure the spannable string
        StaticLayout tempLayout = new StaticLayout(Html.fromHtml(mMessage), mTextField.getPaint(), Integer.MAX_VALUE, android.text.Layout.Alignment.ALIGN_NORMAL, 1f, 0f, false);
        int lineCount = tempLayout.getLineCount();
        mTextWidth = 0;
        for (int i = 0; i < lineCount; i++) {
            mTextWidth += tempLayout.getLineWidth(i);
        }

        mTextWidth += 300; //测量不准确，增加一点长度，使文本显示完整
        mTextDifference = mTextWidth + 5;

        final int duration = (rd ? (int) startX : AnimationHelper.DISPLAY_WIDTH + (int) mTextDifference) / mSpeed * 1000;
        if (duration < 0) return;
        //mMoveTextOut = ObjectAnimator.ofFloat(mTextField, "x", rd ? startX - mTextDifference : getMeasuredWidth(), -mTextDifference);
        mMoveTextOut = ObjectAnimator.ofFloat(mTextField, "x", rd ? startX - mTextDifference : getMeasuredWidth(), -mTextDifference); // TODO: 2016/10/8 to be checked
        mMoveTextOut.setDuration(duration);
        mMoveTextOut.setInterpolator(mInterpolator);
        mMoveTextOut.addListener(new Animator.AnimatorListener() {
            @Override
            public void onAnimationStart(Animator animation) {
                mTextField.setVisibility(VISIBLE);
                mStarted = true;
                StringBuilder sb = new StringBuilder();
                for (String l : mMessageId) {
                    sb.append(l).append(",");
                }
                mMessageIdStr = sb.toString();
                if (StringUtils.trimToNull(mMessageIdStr) != null) {
                    mMessageIdStr = mMessageIdStr.substring(0, mMessageIdStr.lastIndexOf(","));
                }
            }

            @Override
            public void onAnimationEnd(Animator animation) {
                if (mCancelled) {
                    return;
                }
                mStarted = false;
                mTextField.setVisibility(INVISIBLE);
                if (mMessageChanged && StringUtils.trimToNull(mMessage) != null) {
                    mMessageChanged = false;
                    mTextField.setText(extraMsgToSpan());
                    //重设动画属性
                    prepareTextOutAnimation(false, 0);
                    startMarquee();
                } else {
                    resumeMarquee();
                }
            }

            @Override
            public void onAnimationCancel(Animator animation) {

            }

            @Override
            public void onAnimationRepeat(Animator animation) {

            }
        });

        expandTextView();
    }

    public void extractNoticeInfosOrignal(List<Notice> noticeInfos) {
        mMessage = "";
        mMessageId.clear();
        List<String> mesgList = new ArrayList<>();
        for (Notice noticeInfo : noticeInfos) {
            mMessageId.add(String.valueOf(noticeInfo.id));
            mesgList.add(noticeInfo.message);
        }
        //todo:如果不为空最后多空格
        mMessage = genDisplayMessage(mesgList);
        resumeMarquee();
    }

    private Spanned extraMsgToSpan() {
        if (mMessage == null) return new SpannableString("");
        return Html.fromHtml(mMessage, getImageGetterInstance(), null);
    }

    private String genDisplayMessage(List<String> strs) {
        if (strs == null) return "";
        StringBuilder sb = new StringBuilder();
        int seq = 1;
        for (String str : strs) {
            if (mSeparatorType == SEPARATOR_TYPE_SEQ) {
                sb.append(seq++ + ".").append(str).append("   ");
            } else if (mSeparatorType == SEPARATOR_TYPE_TEXT) {
                if (StringUtils.trimToNull(str) != null)
                    sb.append(mSeparatorText).append(str).append("   ");
            }
        }
        return sb.toString();
    }

    public Html.ImageGetter getImageGetterInstance() {
        Html.ImageGetter getter = new Html.ImageGetter() {
            @Override
            public Drawable getDrawable(String source) {
                int fontH = (int) (UiUtils.getPixel(getContext(), 16) * 1.5);
                int id = Integer.parseInt(source);
                Drawable d = getResources().getDrawable(id);
                int height = fontH;
                int width = (int) ((float) d.getIntrinsicWidth() / (float) d
                        .getIntrinsicHeight()) * fontH;
                if (width == 0) {
                    width = d.getIntrinsicWidth();
                }
                d.setBounds(0, -5, width, height);
                return d;
            }
        };

        return getter;
    }

    @Override
    protected void onAttachedToWindow() {
        if (isInEditMode()) return;
        super.onAttachedToWindow();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
    }

    @Override
    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    @Override
    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == VISIBLE && mTextField != null) {
            resumeMarquee(); // TODO: 2016/10/8 暂时屏蔽 by elegant@2016年10月8日19:58:21
        } else if (visibility == GONE) {
            //保存
            saveMarqueeState();
        }
    }

    //恢复跑马灯
    private void resumeMarquee() {
        if (mStarted) return;
        //如果保存了状态，则使用保存的
        //暂时修改为每次都重头开始
        try {//todo 20181224 add to resolve mTextField null point exception
            if (saveState.getBoolean(SaveStateKey.STATE_FLAG)) {
                mMessage = saveState.getString(SaveStateKey.MESSAGE);
                Html.fromHtml(mMessage, getImageGetterInstance(), null);
                String messageIdStr = saveState.getString(SaveStateKey.MESSSAGE_ID);
                String[] meesageIdArr = messageIdStr.split(",");
                mMessageId.clear();
                mMessageId.addAll(Arrays.asList(meesageIdArr));
                float tx = saveState.getFloat(SaveStateKey.TRASLATION_X);
                saveState.clear();
                mTextField.setText(extraMsgToSpan());
                prepareTextOutAnimation(true, tx);
                startMarquee();
            } else {
              //  extractNoticeInfos(cb.getNoticeInfo());
                mTextField.setText(extraMsgToSpan());
                prepareTextOutAnimation(false, 0);
                startMarquee();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    //保存当前跑马灯状态
    private void saveMarqueeState() {
        if (mTextField != null && StringUtils.trimToNull(mTextField.getText().toString()) != null && StringUtils.trimToNull(mMessageIdStr) != null && mStarted) {
            saveState.putBoolean(SaveStateKey.STATE_FLAG, true);
            saveState.putString(SaveStateKey.MESSAGE, mMessage);
            saveState.putString(SaveStateKey.MESSSAGE_ID, mMessageIdStr);
            saveState.putFloat(SaveStateKey.TRASLATION_X, mTextField.getX() + (int) mTextDifference);

            mCancelled = true;
            mStarted = false;
            mTextField.clearAnimation();
            mTextField.setVisibility(INVISIBLE);
            mMoveTextOut.cancel();
        }
    }

//    private void postResumeMarquee2(){
//        this.post(new Runnable() {
//            @Override
//            public void run() {
//                Timber.d("[[[[[postResumeMarquee2");
//                resumeMarquee();
//                NotifyManager.getInstance().getServerNoticeChange();
//            }
//        });
//    }

    //监听NoticeEvent事件
//    @Subscribe(threadMode = ThreadMode.MAIN)
//    public void onNoticeEvent(NotifyManager.NoticeEvent noticeEvent) {
        //发现有更新时间则更新
        //现在不改变，每次完成后均NoticeManager中获取
        // TODO: 2016/10/8 暂时屏蔽，by elegant@2016年10月8日19:52:17
        // ICallBack: 2019/2/16 jaylon fixbug: avoid showing the cutoff message
//        setMessage(noticeEvent.getNoticeInfoList());
//        resumeMarquee();
//    }

    /**
     * onAttachToWindow——>onMeasure——>onSizeChanged——>onLayout——>onMeasure——>onLayout——>onDraw——>onDetachedFromWindow
     */
    public interface CallBack {
        List<Notice> getNoticeInfo();
        void noticesCome(List<Notice> notices);
        void noticeDisplayed(String id);
        void noticesChange();
    }

    public static class Notice {
        public String id;
        public String message;
        public String image;
        public String url;
    }
}
