package com.cv.media.c.dao.converter;

import androidx.room.TypeConverter;

import com.cv.media.lib.storage.GsonInstance;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.Date;

public class DateConverter {
    @TypeConverter
    public String objectToString(Date date) {
        return GsonInstance.getInstance().getGson().toJson(date);
    }

    @TypeConverter
    public Date stringToObject(String json) {
        Type listType = new TypeToken<Date>(){}.getType();
        return GsonInstance.getInstance().getGson().fromJson(json, listType);
    }
}
