package com.cv.media.c.dao.converter;

import androidx.room.TypeConverter;

import com.cv.media.c.dao.enums.EnumDownloadStatus;
import com.cv.media.lib.storage.GsonInstance;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;

public class EnumDownloadStatusConverter {
    @TypeConverter
    public String objectToString(EnumDownloadStatus enumDownloadStatus) {
        return GsonInstance.getInstance().getGson().toJson(enumDownloadStatus);
    }

    @TypeConverter
    public EnumDownloadStatus stringToObject(String json) {
        Type listType = new TypeToken<EnumDownloadStatus>(){}.getType();
        return GsonInstance.getInstance().getGson().fromJson(json, listType);
    }
}
