package com.cv.media.c.dao.converter;

import androidx.room.TypeConverter;

import com.cv.media.c.dao.enums.EnumDownloadType;
import com.cv.media.lib.storage.GsonInstance;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;

public class EnumDownloadTypeConverter {
    @TypeConverter
    public String objectToString(EnumDownloadType type) {
        return GsonInstance.getInstance().getGson().toJson(type);
    }

    @TypeConverter
    public EnumDownloadType stringToObject(String json) {
        Type listType = new TypeToken<EnumDownloadType>(){}.getType();
        return GsonInstance.getInstance().getGson().fromJson(json, listType);
    }
}
