package com.cv.media.c.dao.dao;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.cv.media.c.dao.model.HistoryAlbum;

import java.util.List;

@Dao
public abstract class HistoryAlbumDao {
    @Query("SELECT * FROM HistoryAlbum WHERE subAccountId == :subAccountId AND watchStatus == :watchStatus  ORDER BY playedTime DESC")
    public abstract List<HistoryAlbum> loadAllHistoryAlbum(long subAccountId,int watchStatus);

    @Query("SELECT COUNT(*) FROM HistoryAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId")
    public abstract int getAllHistoryAlbumCount(long accountId, long subAccountId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertHistoryAlbum(HistoryAlbum... historyAlbum);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertHistoryAlbumList(List<HistoryAlbum> historyAlbumList);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    public abstract void updateHistoryAlbum(HistoryAlbum... historyAlbum);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    public abstract void updateHistoryAlbumList(List<HistoryAlbum> historyAlbumList);

    @Query("SELECT * FROM HistoryAlbum WHERE subAccountId == :subAccountId AND metaId == :metaId ")
    public abstract HistoryAlbum loadHistoryAlbum(long subAccountId, long metaId);

    @Query("SELECT * FROM HistoryAlbum")
    public abstract List<HistoryAlbum> loadAllHistoryAlbum();

    @Query("SELECT * FROM HistoryAlbum WHERE subAccountId == :subAccountId  ORDER BY playedTime DESC LIMIT :size")
    public abstract List<HistoryAlbum> loadHistoryAlbumBySize(long subAccountId, int size);

    @Query("SELECT * FROM HistoryAlbum WHERE subAccountId == :subAccountId ORDER BY playedTime DESC")
    public abstract List<HistoryAlbum> loadHistoryAlbum(long subAccountId);

    @Query("SELECT * FROM HistoryAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId ORDER BY playedTime ASC LIMIT 0,1")
    public abstract HistoryAlbum loadOldestHistoryAlbum(long accountId, long subAccountId);

    @Delete
    public abstract void delete(HistoryAlbum... HistoryAlbum);

    @Query("DELETE FROM HistoryAlbum WHERE metaId == :metaId")
    public abstract void deleteById(long metaId);

    @Query("DELETE FROM HistoryAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId")
    public abstract void deleteAll(long accountId, long subAccountId);

    @Query("DELETE FROM HistoryAlbum WHERE watchStatus == :watchStatus")
    public abstract void clearHistoryDb(int watchStatus);

}
