package com.cv.media.c.dao.dao;

import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.cv.media.c.dao.model.FavoriteAlbum;

import java.util.List;

@Dao
public abstract class FavoriteAlbumDao {

    @Query("SELECT * FROM FavoriteAlbum WHERE subAccountId == :subAccountId ORDER BY addTime DESC")
    public abstract List<FavoriteAlbum> observeFavoriteAlbum(long subAccountId);

    @Query("SELECT * FROM FavoriteAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId")
    public abstract List<FavoriteAlbum> loadAllFavoriteAlbum(long accountId, long subAccountId);

    @Query("SELECT COUNT(*) FROM FavoriteAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId")
    public abstract int getAllFavoriteAlbumCount(long accountId, long subAccountId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertFavoriteAlbum(FavoriteAlbum... profileAlbum);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertFavoriteAlbumList(List<FavoriteAlbum> favoriteAlbumList);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    public abstract void updateFavoriteAlbum(FavoriteAlbum... profileAlbum);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    public abstract void updateFavoriteAlbumList(List<FavoriteAlbum> favoriteAlbumList);

    @Query("SELECT * FROM FavoriteAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId AND metaId == :metaId ")
    public abstract FavoriteAlbum loadFavoriteAlbum(long accountId, long subAccountId, long metaId);

    @Query("SELECT * FROM FavoriteAlbum WHERE subAccountId == :subAccountId ORDER BY addTime DESC LIMIT :size")
    public abstract List<FavoriteAlbum> loadFavoriteAlbumBySize(long subAccountId, int size);

    @Delete
    public abstract void delete(FavoriteAlbum... profileAlbum);

    @Query("DELETE FROM FavoriteAlbum WHERE accountId == :accountId AND subAccountId == :subAccountId")
    public abstract void deleteAll(long accountId, long subAccountId);

    @Query("DELETE FROM FavoriteAlbum WHERE metaId == :metaId")
    public abstract void deleteById(long metaId);

    @Query("DELETE FROM FavoriteAlbum")
    public abstract void clearFavoriteDb();

}
