package com.cv.media.c.dao.message.dao;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.cv.media.c.dao.message.model.Message;

import java.util.List;

/**
 * Created by zhangyaoa on 2020/6/3.
 */
@Dao
public interface MessageDao {
    @Query("SELECT * FROM Message")
    public abstract LiveData<List<Message>> loadAllMessage();

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insert(Message... message);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    public abstract void insertMessages(List<Message> messageList);

    @Query("DELETE FROM Message")
    public abstract void deleteAll();
}
