package com.cv.media.c.dao.message.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.cv.media.c.dao.model.AdMessage;

import java.util.List;

@Dao
public interface AdDao {

    @Query("SELECT * FROM AdMessage ORDER BY level ASC")
    List<AdMessage> getMessagesOrdered();

    @Query("SELECT * FROM AdMessage WHERE hostId == :noticeId")
    AdMessage getAdByNoticeId(String noticeId);

    @Query("DELETE FROM AdMessage WHERE hostId == :messageId")
    void deleteMessage(String messageId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void saveAdMessage(AdMessage adMessage);

    @Query("SELECT * FROM AdMessage WHERE updateState == :status")
    List<AdMessage> getAdMessagesByStatus(String status);

    @Query("SELECT * FROM AdMessage WHERE updateState == :status ORDER BY level DESC")
    List<AdMessage> getAdMessagesByStatusOrderDesc(String status);

    @Query("SELECT * FROM AdMessage WHERE imagePath LIKE '%user_guide%' AND updateState = 'Y' ORDER BY level DESC")
    List<AdMessage> getUserGuideAd();

}
