package com.cv.media.c.dao.dao;

import androidx.room.Dao;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;
import androidx.room.Update;

import com.cv.media.c.dao.model.SubInfo;

@Dao
public interface SubDao {

    @Query("SELECT * FROM SubInfo WHERE videoId== :videoId")
    SubInfo getSubInfo(String videoId);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void insertSubInfo(SubInfo subInfo);

    @Update(onConflict = OnConflictStrategy.REPLACE)
    void updateSubInfo(SubInfo subInfo);

    @Query("DELETE FROM SubInfo WHERE videoId == :videoId")
    void deleteSubInfo(String videoId);

    @Query("UPDATE SubInfo SET subtitleTotalLast = :subtitleTotalLast WHERE videoId == :videoId")
    void updateSubInfo(String videoId, boolean subtitleTotalLast);
}
